/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.MethodInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.region.SimpleRegion;
import org.conqat.lib.commons.test.IndexValueClass;
import org.conqat.lib.commons.uniformpath.UniformPath;

@IndexValueClass
public class MethodInfoContainer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final HashMap<OffsetBasedRegion, MethodInfo> methodInfosByRegion = new HashMap();

    public MethodInfoContainer() {
    }

    public MethodInfoContainer(OffsetBasedRegion region, MethodInfo methodInfo) {
        this.methodInfosByRegion.put(region, methodInfo);
    }

    public byte[] serializeCrossAnnotationInfo() throws StorageException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(output);
        try {
            dataOutputStream.writeInt(this.methodInfosByRegion.size());
            for (OffsetBasedRegion region : CollectionUtils.sort(this.methodInfosByRegion.keySet(), (Comparator)SimpleRegion.START_AND_END_COMPARATOR)) {
                dataOutputStream.writeInt(region.getStart());
                dataOutputStream.writeInt(region.getEnd());
                this.methodInfosByRegion.get(region).serializeCrossAnnotationInfo(dataOutputStream);
            }
            return output.toByteArray();
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void deserializeAndAddCrossAnnotationInfo(byte[] input) throws StorageException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(input);
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            int numRegions = dataInputStream.readInt();
            for (int i = 0; i < numRegions; ++i) {
                OffsetBasedRegion region = new OffsetBasedRegion(dataInputStream.readInt(), dataInputStream.readInt());
                this.methodInfosByRegion.get(region).readCrossAnnotationInfo(dataInputStream);
            }
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public Set<AssociatedMethodInfo> getAllMethodInfos(UniformPath uniformPath) {
        HashSet<AssociatedMethodInfo> associatedMethodInfos = HashSet.newHashSet(this.methodInfosByRegion.size());
        for (Map.Entry<OffsetBasedRegion, MethodInfo> entry : this.methodInfosByRegion.entrySet()) {
            associatedMethodInfos.add(new AssociatedMethodInfo(uniformPath, entry.getKey(), entry.getValue()));
        }
        return associatedMethodInfos;
    }

    public boolean isEmpty() {
        return this.methodInfosByRegion.isEmpty();
    }

    public MethodInfo getMethodInfo(OffsetBasedRegion region) {
        if (region.getClass() != OffsetBasedRegion.class) {
            region = new OffsetBasedRegion(region.getStart(), region.getEnd());
        }
        return this.methodInfosByRegion.get(region);
    }

    public void removeMethodInfo(OffsetBasedRegion region) {
        if (region.getClass() != OffsetBasedRegion.class) {
            region = new OffsetBasedRegion(region.getStart(), region.getEnd());
        }
        this.methodInfosByRegion.remove(region);
    }

    public void putMethodInfo(OffsetBasedRegion region, MethodInfo methodInfo) {
        if (region.getClass() != OffsetBasedRegion.class) {
            region = new OffsetBasedRegion(region.getStart(), region.getEnd());
        }
        this.methodInfosByRegion.put(region, methodInfo);
    }

    public Set<Map.Entry<OffsetBasedRegion, MethodInfo>> entrySet() {
        return this.methodInfosByRegion.entrySet();
    }

    public Set<OffsetBasedRegion> keySet() {
        return this.methodInfosByRegion.keySet();
    }

    public static MethodInfoContainer merge(MethodInfoContainer container, MethodInfoContainer newContainer) {
        MethodInfoContainer mergedContainer = new MethodInfoContainer();
        mergedContainer.methodInfosByRegion.putAll(container.methodInfosByRegion);
        mergedContainer.methodInfosByRegion.putAll(newContainer.methodInfosByRegion);
        return mergedContainer;
    }

    public static MethodInfoContainer deserializeWithoutCrossAnnotations(byte[] bytes) {
        MethodInfoContainer methodInfoContainer;
        if (bytes == null) {
            return null;
        }
        MethodInfoContainer container = new MethodInfoContainer();
        ByteArrayInputStream byteArrayStream = new ByteArrayInputStream(bytes);
        try {
            try (DataInputStream dataStream = new DataInputStream(byteArrayStream);){
                while (dataStream.available() > 0) {
                    int startOffset = dataStream.readInt();
                    int endOffset = dataStream.readInt();
                    MethodInfo methodInfo = MethodInfo.deserializeWithoutCrossAnnotationsFrom(dataStream);
                    container.methodInfosByRegion.put(new OffsetBasedRegion(startOffset, endOffset), methodInfo);
                }
            }
            methodInfoContainer = container;
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e.getMessage(), e);
            }
        }
        byteArrayStream.close();
        return methodInfoContainer;
    }

    public byte[] serializeWithoutCrossAnnotations() throws StorageException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        try {
            try (DataOutputStream dataStream = new DataOutputStream(byteArrayStream);){
                for (OffsetBasedRegion region : CollectionUtils.sort(this.methodInfosByRegion.keySet(), (Comparator)SimpleRegion.START_AND_END_COMPARATOR)) {
                    dataStream.writeInt(region.getStart());
                    dataStream.writeInt(region.getEnd());
                    this.methodInfosByRegion.get(region).serializeWithoutCrossAnnotationsTo(dataStream);
                }
            }
            byArray = byteArrayStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteArrayStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new StorageException(e.getMessage(), (Throwable)e);
            }
        }
        byteArrayStream.close();
        return byArray;
    }

    public int hashCode() {
        return Objects.hash(this.methodInfosByRegion);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodInfoContainer) {
            MethodInfoContainer other = (MethodInfoContainer)obj;
            return Objects.equals(this.methodInfosByRegion, other.methodInfosByRegion);
        }
        return false;
    }
}

