/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import com.teamscale.index.testgap.AssociatedMethodInfo;
import org.conqat.lib.commons.lang.ObjectUtils;
import org.conqat.lib.commons.region.OffsetBasedRegion;

public class UsageInfo
implements Comparable<UsageInfo> {
    private final long executionCount;
    private String uniformPathToFile;
    private final OffsetBasedRegion region;
    private final AssociatedMethodInfo methodInfo;

    public UsageInfo(String uniformPath, OffsetBasedRegion region, long executionCount, AssociatedMethodInfo methodInfo) {
        this.uniformPathToFile = uniformPath;
        this.region = region;
        this.methodInfo = methodInfo;
        this.executionCount = executionCount;
    }

    public static UsageInfo createEmpty(String uniformPath) {
        return new UsageInfo(uniformPath, new OffsetBasedRegion(0, 0), 0L, null);
    }

    public long getExecutionCount() {
        return this.executionCount;
    }

    public String getUniformPath() {
        return this.uniformPathToFile;
    }

    public OffsetBasedRegion getAssociatedRegion() {
        return this.region;
    }

    public AssociatedMethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    public String toString() {
        String methodName = "No method info provided";
        if (this.methodInfo != null) {
            methodName = this.methodInfo.getMethodName();
        }
        return String.format("path: %s, region start: %d, region end: %d, method name: %s", this.uniformPathToFile, this.region.getStart(), this.region.getEnd(), methodName);
    }

    @Override
    public int compareTo(UsageInfo other) {
        if (other == null) {
            return 1;
        }
        return ObjectUtils.compareNullSafe((Comparable)this.methodInfo, (Comparable)other.methodInfo);
    }

    void setUniformPathToFile(String uniformPathToFile) {
        this.uniformPathToFile = uniformPathToFile;
    }
}

