/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.AbstractSonarLintEngine;
import org.sonarsource.sonarlint.core.analysis.AnalysisEngine;
import org.sonarsource.sonarlint.core.analysis.api.ActiveRule;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisConfiguration;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisEngineConfiguration;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisResults;
import org.sonarsource.sonarlint.core.analysis.api.Issue;
import org.sonarsource.sonarlint.core.analysis.command.AnalyzeCommand;
import org.sonarsource.sonarlint.core.client.api.common.PluginDetails;
import org.sonarsource.sonarlint.core.client.api.common.analysis.DefaultClientIssue;
import org.sonarsource.sonarlint.core.client.api.common.analysis.IssueListener;
import org.sonarsource.sonarlint.core.client.api.exceptions.SonarLintWrappedException;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneGlobalConfiguration;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneRuleDetails;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneSonarLintEngine;
import org.sonarsource.sonarlint.core.commons.RuleKey;
import org.sonarsource.sonarlint.core.commons.log.ClientLogOutput;
import org.sonarsource.sonarlint.core.commons.progress.ClientProgressMonitor;
import org.sonarsource.sonarlint.core.plugin.commons.PluginsLoadResult;
import org.sonarsource.sonarlint.core.plugin.commons.PluginsLoader;
import org.sonarsource.sonarlint.core.rule.extractor.SonarLintRuleDefinition;

public final class StandaloneSonarLintEngineImpl
extends AbstractSonarLintEngine
implements StandaloneSonarLintEngine {
    private final Collection<PluginDetails> pluginDetails;
    private final Map<String, SonarLintRuleDefinition> allRulesDefinitionsByKey;
    private final AnalysisEngine analysisEngine;

    public StandaloneSonarLintEngineImpl(StandaloneGlobalConfiguration globalConfig) {
        super(globalConfig.getLogOutput());
        this.setLogging(null);
        PluginsLoadResult loadingResult = StandaloneSonarLintEngineImpl.loadPlugins(globalConfig);
        this.pluginDetails = loadingResult.getPluginCheckResultByKeys().values().stream().map(c -> new PluginDetails(c.getPlugin().getKey(), c.getPlugin().getName(), c.getPlugin().getVersion().toString(), c.getSkipReason().orElse(null))).collect(Collectors.toList());
        this.allRulesDefinitionsByKey = StandaloneSonarLintEngineImpl.loadPluginMetadata(loadingResult.getLoadedPlugins(), globalConfig.getEnabledLanguages(), false, false);
        AnalysisEngineConfiguration analysisGlobalConfig = AnalysisEngineConfiguration.builder().setClientPid(globalConfig.getClientPid()).setExtraProperties(globalConfig.extraProperties()).setNodeJs(globalConfig.getNodeJsPath()).setWorkDir(globalConfig.getWorkDir()).setModulesProvider(globalConfig.getModulesProvider()).build();
        this.analysisEngine = new AnalysisEngine(analysisGlobalConfig, loadingResult.getLoadedPlugins(), this.logOutput);
    }

    @Override
    public AnalysisEngine getAnalysisEngine() {
        return this.analysisEngine;
    }

    private static PluginsLoadResult loadPlugins(StandaloneGlobalConfiguration globalConfig) {
        PluginsLoader.Configuration config = new PluginsLoader.Configuration(globalConfig.getPluginPaths(), globalConfig.getEnabledLanguages(), false, Optional.ofNullable(globalConfig.getNodeJsVersion()));
        return new PluginsLoader().load(config);
    }

    @Override
    public Optional<StandaloneRuleDetails> getRuleDetails(String ruleKey) {
        return Optional.ofNullable(this.allRulesDefinitionsByKey.get(ruleKey)).map(StandaloneRuleDetails::new);
    }

    @Override
    public Collection<StandaloneRuleDetails> getAllRuleDetails() {
        return this.allRulesDefinitionsByKey.values().stream().map(StandaloneRuleDetails::new).collect(Collectors.toList());
    }

    @Override
    public AnalysisResults analyze(StandaloneAnalysisConfiguration configuration, IssueListener issueListener, @Nullable ClientLogOutput logOutput, @Nullable ClientProgressMonitor monitor) {
        Objects.requireNonNull(configuration);
        Objects.requireNonNull(issueListener);
        this.setLogging(logOutput);
        AnalysisConfiguration analysisConfig = AnalysisConfiguration.builder().addInputFiles(configuration.inputFiles()).putAllExtraProperties(configuration.extraProperties()).addActiveRules(this.identifyActiveRules(configuration)).setBaseDir(configuration.baseDir()).build();
        AnalyzeCommand analyzeCommand = new AnalyzeCommand(configuration.moduleKey(), analysisConfig, i -> issueListener.handle(new DefaultClientIssue((Issue)i, this.allRulesDefinitionsByKey.get(i.getRuleKey()))), logOutput);
        return this.postAnalysisCommandAndGetResult(analyzeCommand, monitor);
    }

    private Collection<ActiveRule> identifyActiveRules(StandaloneAnalysisConfiguration configuration) {
        Set<String> excludedRules = configuration.excludedRules().stream().map(RuleKey::toString).collect(Collectors.toSet());
        Set<String> includedRules = configuration.includedRules().stream().map(RuleKey::toString).filter(r -> !excludedRules.contains(r)).collect(Collectors.toSet());
        ArrayList filteredActiveRules = new ArrayList();
        filteredActiveRules.addAll(this.allRulesDefinitionsByKey.values().stream().filter(SonarLintRuleDefinition::isActiveByDefault).filter(StandaloneSonarLintEngineImpl.isExcludedByConfiguration(excludedRules)).collect(Collectors.toList()));
        filteredActiveRules.addAll(this.allRulesDefinitionsByKey.values().stream().filter(r -> !r.isActiveByDefault()).filter(StandaloneSonarLintEngineImpl.isIncludedByConfiguration(includedRules)).collect(Collectors.toList()));
        return filteredActiveRules.stream().map(rd -> {
            ActiveRule activeRule = new ActiveRule(rd.getKey(), rd.getLanguage().getLanguageKey());
            HashMap<String, String> effectiveParams = new HashMap<String, String>(rd.getDefaultParams());
            Optional.ofNullable(configuration.ruleParameters().get(RuleKey.parse(rd.getKey()))).ifPresent(effectiveParams::putAll);
            activeRule.setParams(effectiveParams);
            return activeRule;
        }).collect(Collectors.toList());
    }

    private static Predicate<? super SonarLintRuleDefinition> isExcludedByConfiguration(Set<String> excludedRules) {
        return r -> {
            if (excludedRules.contains(r.getKey())) {
                return false;
            }
            for (String deprecatedKey : r.getDeprecatedKeys()) {
                if (!excludedRules.contains(deprecatedKey)) continue;
                LOG.warn("Rule '{}' was excluded using its deprecated key '{}'. Please fix your configuration.", (Object)r.getKey(), (Object)deprecatedKey);
                return false;
            }
            return true;
        };
    }

    private static Predicate<? super SonarLintRuleDefinition> isIncludedByConfiguration(Set<String> includedRules) {
        return r -> {
            if (includedRules.contains(r.getKey())) {
                return true;
            }
            for (String deprecatedKey : r.getDeprecatedKeys()) {
                if (!includedRules.contains(deprecatedKey)) continue;
                LOG.warn("Rule '{}' was included using its deprecated key '{}'. Please fix your configuration.", (Object)r.getKey(), (Object)deprecatedKey);
                return true;
            }
            return false;
        };
    }

    @Override
    public void stop() {
        this.setLogging(null);
        try {
            this.allRulesDefinitionsByKey.clear();
            this.analysisEngine.stop();
        }
        catch (Exception e) {
            throw SonarLintWrappedException.wrap(e);
        }
    }

    @Override
    public Collection<PluginDetails> getPluginDetails() {
        return this.pluginDetails;
    }
}

