/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.api;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonarsource.sonarlint.core.analysis.api.ClientModulesProvider;

@Immutable
public class AnalysisEngineConfiguration {
    private static final String NODE_EXECUTABLE_PROPERTY = "sonar.nodejs.executable";
    private final Path workDir;
    private final Map<String, String> extraProperties;
    private final Path nodeJsPath;
    private final long clientPid;
    private final ClientModulesProvider modulesProvider;

    private AnalysisEngineConfiguration(Builder builder) {
        this.workDir = builder.workDir;
        this.extraProperties = new LinkedHashMap<String, String>(builder.extraProperties);
        this.nodeJsPath = builder.nodeJsPath;
        this.clientPid = builder.clientPid;
        this.modulesProvider = builder.modulesProvider;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Path getWorkDir() {
        return this.workDir;
    }

    public long getClientPid() {
        return this.clientPid;
    }

    public ClientModulesProvider getModulesProvider() {
        return this.modulesProvider;
    }

    public Map<String, String> getEffectiveSettings() {
        HashMap<String, String> props = new HashMap<String, String>(this.extraProperties);
        if (this.nodeJsPath != null) {
            props.put(NODE_EXECUTABLE_PROPERTY, this.nodeJsPath.toString());
        }
        return props;
    }

    public static final class Builder {
        private Path workDir;
        private Map<String, String> extraProperties = Collections.emptyMap();
        private Path nodeJsPath;
        private long clientPid;
        private ClientModulesProvider modulesProvider;

        private Builder() {
        }

        public Builder setWorkDir(Path workDir) {
            this.workDir = workDir;
            return this;
        }

        public Builder setExtraProperties(Map<String, String> extraProperties) {
            this.extraProperties = extraProperties;
            return this;
        }

        public Builder setNodeJs(@Nullable Path nodeJsPath) {
            this.nodeJsPath = nodeJsPath;
            return this;
        }

        public Builder setClientPid(long clientPid) {
            this.clientPid = clientPid;
            return this;
        }

        public Builder setModulesProvider(ClientModulesProvider modulesProvider) {
            this.modulesProvider = modulesProvider;
            return this;
        }

        public AnalysisEngineConfiguration build() {
            return new AnalysisEngineConfiguration(this);
        }
    }
}

