/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonarsource.sonarlint.core.clientapi.SonarLintClient;
import org.sonarsource.sonarlint.core.clientapi.client.http.SelectProxiesParams;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;

@Named
@Singleton
public class ClientProxySelector
extends ProxySelector {
    private final SonarLintLogger logger = SonarLintLogger.get();
    private final SonarLintClient client;

    public ClientProxySelector(SonarLintClient client) {
        this.client = client;
    }

    @Override
    public List<Proxy> select(URI uri) {
        try {
            return this.client.selectProxies(new SelectProxiesParams(uri.toString())).get().getProxies().stream().map(p -> {
                if (p.getType() == Proxy.Type.DIRECT) {
                    return Proxy.NO_PROXY;
                }
                if (p.getPort() < 0 || p.getPort() > 65535) {
                    throw new IllegalStateException("Port is outside the valid range for hostname: " + p.getHostname());
                }
                return new Proxy(p.getType(), new InetSocketAddress(p.getHostname(), p.getPort()));
            }).collect(Collectors.toList());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.warn("Interrupted!", e);
        }
        catch (IllegalStateException | ExecutionException e) {
            this.logger.warn("Unable to get proxy", e);
        }
        return List.of();
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }
}

