/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin.commons.loading;

import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonarsource.sonarlint.core.commons.Version;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

public class SonarPluginManifest {
    public static final String KEY_ATTRIBUTE = "Plugin-Key";
    public static final String MAIN_CLASS_ATTRIBUTE = "Plugin-Class";
    public static final String NAME_ATTRIBUTE = "Plugin-Name";
    public static final String VERSION_ATTRIBUTE = "Plugin-Version";
    public static final String SONAR_VERSION_ATTRIBUTE = "Sonar-Version";
    public static final String DEPENDENCIES_ATTRIBUTE = "Plugin-Dependencies";
    public static final String REQUIRE_PLUGINS_ATTRIBUTE = "Plugin-RequirePlugins";
    public static final String BASE_PLUGIN = "Plugin-Base";
    public static final String JRE_MIN_VERSION = "Jre-Min-Version";
    public static final String NODEJS_MIN_VERSION = "NodeJs-Min-Version";
    private final String key;
    private final String name;
    private final String mainClass;
    private final String version;
    private final Optional<Version> sonarMinVersion;
    private final List<String> dependencies;
    private final String basePluginKey;
    private final List<RequiredPlugin> requiredPlugins;
    private final Optional<Version> jreMinVersion;
    private final Optional<Version> nodeJsMinVersion;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SonarPluginManifest fromJar(Path jarPath) {
        try (JarFile jar = new JarFile(jarPath.toFile());){
            Manifest manifest = jar.getManifest();
            if (manifest == null) throw new IllegalStateException("No manifest in jar: " + jarPath.toAbsolutePath());
            SonarPluginManifest sonarPluginManifest = new SonarPluginManifest(manifest);
            return sonarPluginManifest;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while reading plugin manifest from jar: " + jarPath.toAbsolutePath(), e);
        }
    }

    public SonarPluginManifest(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        this.key = Objects.requireNonNull(attributes.getValue(KEY_ATTRIBUTE), "Plugin key is mandatory");
        this.mainClass = attributes.getValue(MAIN_CLASS_ATTRIBUTE);
        this.name = attributes.getValue(NAME_ATTRIBUTE);
        this.version = attributes.getValue(VERSION_ATTRIBUTE);
        this.sonarMinVersion = Optional.ofNullable(attributes.getValue(SONAR_VERSION_ATTRIBUTE)).map(Version::create);
        this.basePluginKey = attributes.getValue(BASE_PLUGIN);
        String deps = attributes.getValue(DEPENDENCIES_ATTRIBUTE);
        this.dependencies = List.of(StringUtils.split(StringUtils.defaultString(deps), ' '));
        String requires = attributes.getValue(REQUIRE_PLUGINS_ATTRIBUTE);
        this.requiredPlugins = Stream.of(StringUtils.split(StringUtils.defaultString(requires), ',')).map(RequiredPlugin::parse).collect(Collectors.toList());
        this.jreMinVersion = Optional.ofNullable(attributes.getValue(JRE_MIN_VERSION)).map(Version::create);
        this.nodeJsMinVersion = Optional.ofNullable(attributes.getValue(NODEJS_MIN_VERSION)).map(Version::create);
    }

    public String getKey() {
        return this.key;
    }

    @CheckForNull
    public String getName() {
        return this.name;
    }

    public List<RequiredPlugin> getRequiredPlugins() {
        return this.requiredPlugins;
    }

    @CheckForNull
    public String getVersion() {
        return this.version;
    }

    public Optional<Version> getSonarMinVersion() {
        return this.sonarMinVersion;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    @CheckForNull
    public String getBasePluginKey() {
        return this.basePluginKey;
    }

    public Optional<Version> getJreMinVersion() {
        return this.jreMinVersion;
    }

    public Optional<Version> getNodeJsMinVersion() {
        return this.nodeJsMinVersion;
    }

    public static class RequiredPlugin {
        private static final Pattern PARSER = Pattern.compile("\\w+:.+");
        private final String key;
        private final Version minimalVersion;

        public RequiredPlugin(String key, Version minimalVersion) {
            this.key = key;
            this.minimalVersion = minimalVersion;
        }

        public String getKey() {
            return this.key;
        }

        public Version getMinimalVersion() {
            return this.minimalVersion;
        }

        public static RequiredPlugin parse(String s) {
            if (!PARSER.matcher(s).matches()) {
                throw new IllegalArgumentException("Manifest field does not have correct format: " + s);
            }
            String[] fields = StringUtils.split(s, ':');
            return new RequiredPlugin(fields[0], Version.create(fields[1]).removeQualifier());
        }
    }
}

