/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi;

import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.http.HttpClient;
import org.sonarsource.sonarlint.core.http.HttpConnectionListener;
import org.sonarsource.sonarlint.core.serverapi.EndpointParams;
import org.sonarsource.sonarlint.core.serverapi.exception.NotFoundException;
import org.sonarsource.sonarlint.core.serverapi.exception.ServerErrorException;
import org.sonarsource.sonarlint.shaded.com.google.gson.JsonArray;
import org.sonarsource.sonarlint.shaded.com.google.gson.JsonElement;
import org.sonarsource.sonarlint.shaded.com.google.gson.JsonObject;
import org.sonarsource.sonarlint.shaded.com.google.gson.JsonParser;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

public class ServerApiHelper {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    public static final int PAGE_SIZE = 500;
    public static final int MAX_PAGES = 20;
    private final HttpClient client;
    private final EndpointParams endpointParams;

    public ServerApiHelper(EndpointParams endpointParams, HttpClient client) {
        this.endpointParams = endpointParams;
        this.client = client;
    }

    public boolean isSonarCloud() {
        return this.endpointParams.isSonarCloud();
    }

    public HttpClient.Response get(String path) {
        HttpClient.Response response = this.rawGet(path);
        if (!response.isSuccessful()) {
            throw ServerApiHelper.handleError(response);
        }
        return response;
    }

    public CompletableFuture<HttpClient.Response> getAsync(String path) {
        return this.rawGetAsync(path).thenApply(response -> {
            if (!response.isSuccessful()) {
                throw ServerApiHelper.handleError(response);
            }
            return response;
        });
    }

    public CompletableFuture<HttpClient.Response> postAsync(String url, String contentType, String body) {
        return this.rawPostAsync(url, contentType, body).thenApply(response -> {
            if (!response.isSuccessful()) {
                throw ServerApiHelper.handleError(response);
            }
            return response;
        });
    }

    public HttpClient.Response rawGet(String relativePath) {
        Instant startTime = Instant.now();
        String url = this.buildEndpointUrl(relativePath);
        HttpClient.Response response = this.client.get(url);
        ServerApiHelper.logTime(startTime, url, response.code());
        return response;
    }

    public CompletableFuture<HttpClient.Response> rawGetAsync(String relativePath) {
        Instant startTime = Instant.now();
        String url = this.buildEndpointUrl(relativePath);
        return this.client.getAsync(url).whenComplete((response, error) -> ServerApiHelper.logTime(startTime, url, response != null ? response.code() : -1));
    }

    public CompletableFuture<HttpClient.Response> rawPostAsync(String relativePath, String contentType, String body) {
        Instant startTime = Instant.now();
        String url = this.buildEndpointUrl(relativePath);
        return this.client.postAsync(url, contentType, body).whenComplete((response, error) -> ServerApiHelper.logTime(startTime, url, response != null ? response.code() : -1));
    }

    private static void logTime(Instant startTime, String url, int responseCode) {
        Duration duration = Duration.between(startTime, Instant.now());
        LOG.debug("{} {} {} | response time={}ms", "GET", responseCode, url, duration.toMillis());
    }

    private String buildEndpointUrl(String relativePath) {
        return ServerApiHelper.concat(this.endpointParams.getBaseUrl(), relativePath);
    }

    public static String concat(String baseUrl, String relativePath) {
        return StringUtils.appendIfMissing(baseUrl, (CharSequence)"/", new CharSequence[0]) + (relativePath.startsWith("/") ? relativePath.substring(1) : relativePath);
    }

    public static RuntimeException handleError(HttpClient.Response toBeClosed) {
        try (HttpClient.Response failedResponse = toBeClosed;){
            if (failedResponse.code() == 401) {
                IllegalStateException illegalStateException = new IllegalStateException("Not authorized. Please check server credentials.");
                return illegalStateException;
            }
            if (failedResponse.code() == 403) {
                IllegalStateException illegalStateException = new IllegalStateException(ServerApiHelper.tryParseAsJsonError(failedResponse));
                return illegalStateException;
            }
            if (failedResponse.code() == 404) {
                NotFoundException notFoundException = new NotFoundException(ServerApiHelper.formatHttpFailedResponse(failedResponse, null));
                return notFoundException;
            }
            if (failedResponse.code() >= 500) {
                ServerErrorException serverErrorException = new ServerErrorException(ServerApiHelper.formatHttpFailedResponse(failedResponse, null));
                return serverErrorException;
            }
            String errorMsg = ServerApiHelper.tryParseAsJsonError(failedResponse);
            IllegalStateException illegalStateException = new IllegalStateException(ServerApiHelper.formatHttpFailedResponse(failedResponse, errorMsg));
            return illegalStateException;
        }
    }

    private static String formatHttpFailedResponse(HttpClient.Response failedResponse, @Nullable String errorMsg) {
        return "Error " + failedResponse.code() + " on " + failedResponse.url() + (String)(errorMsg != null ? ": " + errorMsg : "");
    }

    @CheckForNull
    private static String tryParseAsJsonError(HttpClient.Response response) {
        String content = response.bodyAsString();
        if (StringUtils.isBlank(content)) {
            return null;
        }
        JsonObject obj = JsonParser.parseString(content).getAsJsonObject();
        JsonArray errors = obj.getAsJsonArray("errors");
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (JsonElement e : errors) {
            errorMessages.add(e.getAsJsonObject().get("msg").getAsString());
        }
        return String.join((CharSequence)", ", errorMessages);
    }

    public Optional<String> getOrganizationKey() {
        return this.endpointParams.getOrganization();
    }

    public <G, F> void getPaginated(String relativeUrlWithoutPaginationParams, CheckedFunction<InputStream, G> responseParser, Function<G, Number> getPagingTotal, Function<G, List<F>> itemExtractor, Consumer<F> itemConsumer, boolean limitToTwentyPages, ProgressMonitor progress) {
        AtomicInteger page = new AtomicInteger(0);
        AtomicBoolean stop = new AtomicBoolean(false);
        AtomicInteger loaded = new AtomicInteger(0);
        do {
            page.incrementAndGet();
            StringBuilder fullUrl = new StringBuilder(relativeUrlWithoutPaginationParams);
            fullUrl.append(relativeUrlWithoutPaginationParams.contains("?") ? "&" : "?");
            fullUrl.append("ps=500&p=").append(page);
            ServerApiHelper.consumeTimed(() -> this.rawGet(fullUrl.toString()), response -> ServerApiHelper.processPage(relativeUrlWithoutPaginationParams, responseParser, getPagingTotal, itemExtractor, itemConsumer, limitToTwentyPages, progress, page, stop, loaded, response), duration -> LOG.debug("Page downloaded in {}ms", (Object)duration));
        } while (!stop.get());
    }

    private static <F, G> void processPage(String baseUrl, CheckedFunction<InputStream, G> responseParser, Function<G, Number> getPagingTotal, Function<G, List<F>> itemExtractor, Consumer<F> itemConsumer, boolean limitToTwentyPages, ProgressMonitor progress, AtomicInteger page, AtomicBoolean stop, AtomicInteger loaded, HttpClient.Response response) throws IOException {
        G protoBufResponse;
        if (!response.isSuccessful()) {
            throw ServerApiHelper.handleError(response);
        }
        try (InputStream body = response.bodyAsStream();){
            protoBufResponse = responseParser.apply(body);
        }
        List<F> items = itemExtractor.apply(protoBufResponse);
        for (F item : items) {
            itemConsumer.accept(item);
            loaded.incrementAndGet();
        }
        boolean isEmpty = items.isEmpty();
        long pagingTotal = getPagingTotal.apply(protoBufResponse).longValue();
        stop.set(isEmpty || pagingTotal > 0L && (long)(page.get() * 500) >= pagingTotal);
        if (!stop.get() && limitToTwentyPages && page.get() >= 20) {
            stop.set(true);
            LOG.debug("Limiting number of requested pages from '{}' to {}. Some of the data won't be fetched", (Object)baseUrl, (Object)20);
        }
        progress.setProgressAndCheckCancel("Page " + page, (float)loaded.get() / (float)pagingTotal);
    }

    public HttpClient.AsyncRequest getEventStream(String path, HttpConnectionListener connectionListener, Consumer<String> messageConsumer) {
        return this.client.getEventStream(this.buildEndpointUrl(path), connectionListener, messageConsumer);
    }

    public static <G> G processTimed(Supplier<HttpClient.Response> responseSupplier, IOFunction<HttpClient.Response, G> responseProcessor, LongConsumer durationConsumer) {
        G result;
        Instant startTime = Instant.now();
        try (HttpClient.Response response = responseSupplier.get();){
            result = responseProcessor.apply(response);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to parse WS response: " + e.getMessage(), e);
        }
        durationConsumer.accept(Duration.between(startTime, Instant.now()).toMillis());
        return result;
    }

    public static <G> CompletableFuture<G> processTimed(CompletableFuture<HttpClient.Response> futureResponse, IOFunction<HttpClient.Response, G> responseProcessor, LongConsumer durationConsumer) {
        Instant startTime = Instant.now();
        return futureResponse.thenApply(response -> {
            HttpClient.Response response2 = response;
            try {
                Object processed = responseProcessor.apply((HttpClient.Response)response);
                durationConsumer.accept(Duration.between(startTime, Instant.now()).toMillis());
                Object r = processed;
                if (response2 != null) {
                    response2.close();
                }
                return r;
            }
            catch (Throwable throwable) {
                try {
                    if (response2 != null) {
                        try {
                            response2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to parse WS response: " + e.getMessage(), e);
                }
            }
        });
    }

    public static void consumeTimed(Supplier<HttpClient.Response> responseSupplier, IOConsumer<HttpClient.Response> responseConsumer, LongConsumer durationConsumer) {
        ServerApiHelper.processTimed(responseSupplier, (HttpClient.Response r) -> {
            responseConsumer.accept((HttpClient.Response)r);
            return null;
        }, durationConsumer);
    }

    @FunctionalInterface
    public static interface IOConsumer<T> {
        public void accept(T var1) throws IOException;
    }

    @FunctionalInterface
    public static interface IOFunction<T, R> {
        public R apply(T var1) throws IOException;
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws IOException;
    }
}

