/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.push.parsing;

import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.CleanCodeAttribute;
import org.sonarsource.sonarlint.core.commons.ImpactSeverity;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.RuleType;
import org.sonarsource.sonarlint.core.commons.SoftwareQuality;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.serverapi.push.TaintVulnerabilityRaisedEvent;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.EventParser;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.common.ImpactPayload;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.common.LocationPayload;
import org.sonarsource.sonarlint.core.serverapi.util.ServerApiUtils;
import org.sonarsource.sonarlint.shaded.com.google.gson.Gson;

public class TaintVulnerabilityRaisedEventParser
implements EventParser<TaintVulnerabilityRaisedEvent> {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final Gson gson = new Gson();

    @Override
    public Optional<TaintVulnerabilityRaisedEvent> parse(String jsonData) {
        TaintVulnerabilityRaisedEventPayload payload = this.gson.fromJson(jsonData, TaintVulnerabilityRaisedEventPayload.class);
        if (payload.isInvalid()) {
            LOG.error("Invalid payload for 'TaintVulnerabilityRaised' event: {}", (Object)jsonData);
            return Optional.empty();
        }
        return Optional.of(new TaintVulnerabilityRaisedEvent(payload.key, payload.projectKey, payload.branch, Instant.ofEpochMilli(payload.creationDate), payload.ruleKey, IssueSeverity.valueOf(payload.severity), RuleType.valueOf(payload.type), TaintVulnerabilityRaisedEventParser.adapt(payload.mainLocation), TaintVulnerabilityRaisedEventParser.adapt(payload.flows), payload.ruleDescriptionContextKey, TaintVulnerabilityRaisedEventParser.adapt(payload.cleanCodeAttribute), TaintVulnerabilityRaisedEventParser.adapt(payload.impacts)));
    }

    private static List<TaintVulnerabilityRaisedEvent.Flow> adapt(List<TaintVulnerabilityRaisedEventPayload.FlowPayload> flows) {
        return flows.stream().map(f -> new TaintVulnerabilityRaisedEvent.Flow(f.locations.stream().map(TaintVulnerabilityRaisedEventParser::adapt).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    public static TaintVulnerabilityRaisedEvent.Location adapt(LocationPayload payload) {
        return new TaintVulnerabilityRaisedEvent.Location(payload.getFilePath(), payload.getMessage(), TaintVulnerabilityRaisedEventParser.adapt(payload.getTextRange()));
    }

    public static CleanCodeAttribute adapt(String cleanCodeAttribute) {
        return Optional.ofNullable(cleanCodeAttribute).map(CleanCodeAttribute::valueOf).orElse(null);
    }

    public static Map<SoftwareQuality, ImpactSeverity> adapt(@Nullable ImpactPayload[] payloads) {
        if (payloads == null) {
            return Map.of();
        }
        return Arrays.stream(payloads).collect(Collectors.toMap(payload -> SoftwareQuality.valueOf(payload.getSoftwareQuality()), payload -> ImpactSeverity.valueOf(payload.getSeverity())));
    }

    private static TaintVulnerabilityRaisedEvent.Location.TextRange adapt(LocationPayload.TextRangePayload payload) {
        return new TaintVulnerabilityRaisedEvent.Location.TextRange(payload.getStartLine(), payload.getStartLineOffset(), payload.getEndLine(), payload.getEndLineOffset(), payload.getHash());
    }

    private static class TaintVulnerabilityRaisedEventPayload {
        private String key;
        private String projectKey;
        private String branch;
        private long creationDate;
        private String ruleKey;
        private String severity;
        private String type;
        private LocationPayload mainLocation;
        private List<FlowPayload> flows;
        @Nullable
        private String ruleDescriptionContextKey;
        @Nullable
        private String cleanCodeAttribute;
        @Nullable
        private ImpactPayload[] impacts;

        private TaintVulnerabilityRaisedEventPayload() {
        }

        private boolean isInvalid() {
            return ServerApiUtils.isBlank(this.key) || ServerApiUtils.isBlank(this.projectKey) || ServerApiUtils.isBlank(this.branch) || this.creationDate == 0L || ServerApiUtils.isBlank(this.ruleKey) || ServerApiUtils.isBlank(this.severity) || ServerApiUtils.isBlank(this.type) || Objects.isNull(this.mainLocation) || this.mainLocation.isInvalid() || Objects.isNull(this.flows) || this.flows.stream().anyMatch(rec$ -> ((FlowPayload)rec$).isInvalid());
        }

        private static class FlowPayload {
            private List<LocationPayload> locations;

            private FlowPayload() {
            }

            private boolean isInvalid() {
                return Objects.isNull(this.locations) || this.locations.stream().anyMatch(LocationPayload::isInvalid);
            }
        }
    }
}

