/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection.storage;

import com.google.protobuf.Message;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.sonarsource.sonarlint.core.commons.NewCodeDefinition;
import org.sonarsource.sonarlint.core.commons.NewCodeMode;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.serverconnection.FileUtils;
import org.sonarsource.sonarlint.core.serverconnection.proto.Sonarlint;
import org.sonarsource.sonarlint.core.serverconnection.storage.ProtobufFileUtil;
import org.sonarsource.sonarlint.core.serverconnection.storage.RWLock;

public class NewCodeDefinitionStorage {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    public static final String NEW_CODE_DEFINITION_PB = "new_code_definition.pb";
    private final Path storageFilePath;
    private final RWLock rwLock = new RWLock();

    public NewCodeDefinitionStorage(Path rootPath) {
        this.storageFilePath = rootPath.resolve(NEW_CODE_DEFINITION_PB);
    }

    public void store(NewCodeDefinition newCodeDefinition) {
        FileUtils.mkdirs(this.storageFilePath.getParent());
        Sonarlint.NewCodeDefinition newCodeDefinitionToStore = NewCodeDefinitionStorage.adapt(newCodeDefinition);
        LOG.debug("Storing new code definition in {}", (Object)this.storageFilePath);
        this.rwLock.write(() -> ProtobufFileUtil.writeToFile((Message)newCodeDefinitionToStore, this.storageFilePath));
    }

    public Optional<NewCodeDefinition> read() {
        return this.rwLock.read(() -> Files.exists(this.storageFilePath, new LinkOption[0]) ? Optional.of(NewCodeDefinitionStorage.adapt(ProtobufFileUtil.readFile(this.storageFilePath, Sonarlint.NewCodeDefinition.parser()))) : Optional.empty());
    }

    static Sonarlint.NewCodeDefinition adapt(NewCodeDefinition newCodeDefinition) {
        NewCodeDefinition.NewCodePreviousVersion newCodePreviousVersion;
        String version;
        Sonarlint.NewCodeDefinition.Builder builder = Sonarlint.NewCodeDefinition.newBuilder().setMode(Sonarlint.NewCodeDefinitionMode.valueOf(newCodeDefinition.getMode().name()));
        if (newCodeDefinition.getMode() == NewCodeMode.NUMBER_OF_DAYS) {
            NewCodeDefinition.NewCodeNumberOfDays newCodeNumberOfDays = (NewCodeDefinition.NewCodeNumberOfDays)newCodeDefinition;
            builder.setDays(newCodeNumberOfDays.getDays());
        }
        if (newCodeDefinition.getMode() != NewCodeMode.REFERENCE_BRANCH) {
            NewCodeDefinition.NewCodeDefinitionWithDate newCodeDefinitionWithDate = (NewCodeDefinition.NewCodeDefinitionWithDate)newCodeDefinition;
            builder.setThresholdDate(newCodeDefinitionWithDate.getThresholdDate());
        } else {
            NewCodeDefinition.NewCodeReferenceBranch newCodeReferenceBranch = (NewCodeDefinition.NewCodeReferenceBranch)newCodeDefinition;
            builder.setReferenceBranch(newCodeReferenceBranch.getBranchName());
        }
        if (newCodeDefinition.getMode() == NewCodeMode.PREVIOUS_VERSION && (version = (newCodePreviousVersion = (NewCodeDefinition.NewCodePreviousVersion)newCodeDefinition).getVersion()) != null) {
            builder.setVersion(version);
        }
        return builder.build();
    }

    static NewCodeDefinition adapt(Sonarlint.NewCodeDefinition newCodeDefinition) {
        long thresholdDate = newCodeDefinition.getThresholdDate();
        Sonarlint.NewCodeDefinitionMode mode = newCodeDefinition.getMode();
        switch (mode) {
            case NUMBER_OF_DAYS: {
                return NewCodeDefinition.withNumberOfDays(newCodeDefinition.getDays(), thresholdDate);
            }
            case PREVIOUS_VERSION: {
                String version = newCodeDefinition.hasVersion() ? newCodeDefinition.getVersion() : null;
                return NewCodeDefinition.withPreviousVersion(thresholdDate, version);
            }
            case REFERENCE_BRANCH: {
                return NewCodeDefinition.withReferenceBranch(newCodeDefinition.getReferenceBranch());
            }
            case SPECIFIC_ANALYSIS: {
                return NewCodeDefinition.withSpecificAnalysis(thresholdDate);
            }
        }
        throw new IllegalArgumentException("Unsupported mode: " + mode);
    }
}

