/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.shaded.org.springframework.aop.scope;

import java.lang.reflect.Modifier;
import org.sonarsource.sonarlint.shaded.org.springframework.aop.framework.AopInfrastructureBean;
import org.sonarsource.sonarlint.shaded.org.springframework.aop.framework.ProxyConfig;
import org.sonarsource.sonarlint.shaded.org.springframework.aop.framework.ProxyFactory;
import org.sonarsource.sonarlint.shaded.org.springframework.aop.scope.DefaultScopedObject;
import org.sonarsource.sonarlint.shaded.org.springframework.aop.support.DelegatingIntroductionInterceptor;
import org.sonarsource.sonarlint.shaded.org.springframework.aop.target.SimpleBeanTargetSource;
import org.sonarsource.sonarlint.shaded.org.springframework.beans.factory.BeanFactory;
import org.sonarsource.sonarlint.shaded.org.springframework.beans.factory.BeanFactoryAware;
import org.sonarsource.sonarlint.shaded.org.springframework.beans.factory.FactoryBean;
import org.sonarsource.sonarlint.shaded.org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.sonarsource.sonarlint.shaded.org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.sonarsource.sonarlint.shaded.org.springframework.lang.Nullable;
import org.sonarsource.sonarlint.shaded.org.springframework.util.Assert;
import org.sonarsource.sonarlint.shaded.org.springframework.util.ClassUtils;

public class ScopedProxyFactoryBean
extends ProxyConfig
implements FactoryBean<Object>,
BeanFactoryAware,
AopInfrastructureBean {
    private final SimpleBeanTargetSource scopedTargetSource = new SimpleBeanTargetSource();
    @Nullable
    private String targetBeanName;
    @Nullable
    private Object proxy;

    public ScopedProxyFactoryBean() {
        this.setProxyTargetClass(true);
    }

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
        this.scopedTargetSource.setTargetBeanName(targetBeanName);
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof ConfigurableBeanFactory)) {
            throw new IllegalStateException("Not running in a ConfigurableBeanFactory: " + beanFactory);
        }
        ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)beanFactory;
        this.scopedTargetSource.setBeanFactory(beanFactory);
        ProxyFactory pf = new ProxyFactory();
        pf.copyFrom(this);
        pf.setTargetSource(this.scopedTargetSource);
        Assert.notNull((Object)this.targetBeanName, "Property 'targetBeanName' is required");
        Class<?> beanType = beanFactory.getType(this.targetBeanName);
        if (beanType == null) {
            throw new IllegalStateException("Cannot create scoped proxy for bean '" + this.targetBeanName + "': Target type could not be determined at the time of proxy creation.");
        }
        if (!this.isProxyTargetClass() || beanType.isInterface() || Modifier.isPrivate(beanType.getModifiers())) {
            pf.setInterfaces(ClassUtils.getAllInterfacesForClass(beanType, cbf.getBeanClassLoader()));
        }
        DefaultScopedObject scopedObject = new DefaultScopedObject(cbf, this.scopedTargetSource.getTargetBeanName());
        pf.addAdvice(new DelegatingIntroductionInterceptor(scopedObject));
        pf.addInterface(AopInfrastructureBean.class);
        this.proxy = pf.getProxy(cbf.getBeanClassLoader());
    }

    @Override
    public Object getObject() {
        if (this.proxy == null) {
            throw new FactoryBeanNotInitializedException();
        }
        return this.proxy;
    }

    @Override
    public Class<?> getObjectType() {
        if (this.proxy != null) {
            return this.proxy.getClass();
        }
        return this.scopedTargetSource.getTargetClass();
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

