/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core.xpath;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.xpath.ShallowEntityNavigator;
import eu.cqse.check.framework.core.xpath.functions.AllModifiersSelectionFunction;
import eu.cqse.check.framework.core.xpath.functions.AllTokensSelectionFunction;
import eu.cqse.check.framework.core.xpath.functions.AnyModifierSelectionFunction;
import eu.cqse.check.framework.core.xpath.functions.AnyTokenSelectionFunction;
import eu.cqse.check.framework.core.xpath.functions.NameMatchesFunction;
import eu.cqse.check.framework.core.xpath.functions.SubTypeSelectionFunction;
import eu.cqse.check.framework.core.xpath.functions.TokenSequenceFunction;
import eu.cqse.check.framework.core.xpath.functions.TypeSelectionFunction;
import java.util.HashMap;
import java.util.Map;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jaxen.BaseXPath;
import org.jaxen.Function;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;
import org.jaxen.SimpleFunctionContext;

public final class CheckXPathUtils {
    private static final Map<String, Function> NAME_TO_FUNCTION_MAP = new HashMap<String, Function>();
    private static final Map<String, BaseXPath> XPATH_CACHE = new HashMap<String, BaseXPath>();

    public static BaseXPath getXPath(String xPath) throws CheckException {
        BaseXPath path;
        if (XPATH_CACHE.containsKey(xPath)) {
            return XPATH_CACHE.get(xPath);
        }
        try {
            path = new BaseXPath(xPath, (Navigator)new ShallowEntityNavigator());
        }
        catch (JaxenException e) {
            throw new CheckException("Error compiling xpath: " + e.getMessage(), (Exception)((Object)e));
        }
        SimpleFunctionContext context = (SimpleFunctionContext)path.getFunctionContext();
        for (Map.Entry<String, Function> entry : NAME_TO_FUNCTION_MAP.entrySet()) {
            context.registerFunction("", entry.getKey(), entry.getValue());
        }
        XPATH_CACHE.put(xPath, path);
        return path;
    }

    private CheckXPathUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    static {
        NAME_TO_FUNCTION_MAP.put("type", new TypeSelectionFunction());
        NAME_TO_FUNCTION_MAP.put("subtype", new SubTypeSelectionFunction());
        NAME_TO_FUNCTION_MAP.put("name-matches", new NameMatchesFunction());
        NAME_TO_FUNCTION_MAP.put("modifiers", new AllModifiersSelectionFunction());
        NAME_TO_FUNCTION_MAP.put("anymodifier", new AnyModifierSelectionFunction());
        NAME_TO_FUNCTION_MAP.put("tokens", new AllTokensSelectionFunction());
        NAME_TO_FUNCTION_MAP.put("anytoken", new AnyTokenSelectionFunction());
        NAME_TO_FUNCTION_MAP.put("token-sequence", new TokenSequenceFunction());
    }
}

