/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.swift;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import eu.cqse.check.framework.preprocessor.swift.EvaluationException;
import eu.cqse.check.framework.preprocessor.swift.SwiftCompilerControlConfig;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.IEvaluableConditionValue;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.ParseException;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.PlatformConditionParseResult;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.SwiftPlatformConditions;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.util.tokens.TokenStream;
import eu.cqse.check.framework.util.tokens.TokenUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

class SwiftCompilationCondition {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TokenStream conditionTokens;
    private final Deque<Boolean> values = new ArrayDeque<Boolean>();
    private final Deque<IToken> operators = new ArrayDeque<IToken>();
    private final SwiftCompilerControlConfig config;

    private SwiftCompilationCondition(@NonNull SwiftCompilerControlConfig config, @NonNull List<IToken> rawConditionTokens) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull(rawConditionTokens);
        Preconditions.checkArgument((!rawConditionTokens.isEmpty() ? 1 : 0) != 0, (Object)"Condition tokens must not be empty");
        this.config = config;
        this.conditionTokens = SwiftCompilationCondition.filterAndWrapRawConditionTokens(rawConditionTokens);
        Verify.verify((!this.conditionTokens.isExhausted() ? 1 : 0) != 0, (String)"Filtered condition tokens must not be empty", (Object[])new Object[0]);
    }

    private static @NonNull TokenStream filterAndWrapRawConditionTokens(@NonNull List<IToken> rawTokens) {
        List<IToken> filteredTokens = rawTokens.stream().filter(t -> !TokenUtils.isCommentToken(t) && t.getType() != ETokenType.EOL).toList();
        return new TokenStream(filteredTokens, 0);
    }

    private static int precedence(@NonNull IToken token) {
        return switch (token.getType()) {
            case ETokenType.NOT -> 3;
            case ETokenType.ANDAND -> 2;
            case ETokenType.OROR -> 1;
            default -> -1;
        };
    }

    private static boolean evaluateLiteral(@NonNull IToken token) {
        String value = token.getText();
        return !value.equalsIgnoreCase("false");
    }

    private boolean evaluateIdentifier(@NonNull IToken identifierToken) throws EvaluationException {
        try {
            Optional<PlatformConditionParseResult> maybePlatformCondition = SwiftPlatformConditions.parse(this.conditionTokens);
            return maybePlatformCondition.map(parseResult -> this.evaluatePlatformCondition((PlatformConditionParseResult)parseResult, identifierToken)).orElseGet(() -> this.evaluateCustomFlag(identifierToken));
        }
        catch (ParseException e) {
            throw new EvaluationException("Could not parse platform condition '%s'".formatted(identifierToken.getText()), e);
        }
    }

    private boolean evaluatePlatformCondition(@NonNull PlatformConditionParseResult parsedCondition, @NonNull IToken identifierToken) {
        Set<Object> configValues = this.config.getPlatformConditionValues(parsedCondition.condition().name);
        if (configValues.isEmpty()) {
            LOGGER.warn("Swift platform condition '{}': No value configured. Encountered at '{}:{}'. Unconfigured platform conditions always evaluate to 'false'. Configure a suitable value for the platform condition in the analysis profile.", (Object)parsedCondition.condition().name, (Object)identifierToken.getOriginId(), (Object)(identifierToken.getLineNumber() + 1));
            return false;
        }
        IEvaluableConditionValue parsedValue = parsedCondition.value();
        List<Boolean> evaluatedValues = configValues.stream().map(parsedValue::evaluate).filter(Optional::isPresent).map(Optional::get).toList();
        if (configValues.size() != evaluatedValues.size()) {
            LOGGER.warn("Swift platform condition '{}': At least one of the candidate configuration values could not be evaluated: {}", (Object)parsedCondition.condition().name, (Object)configValues.stream().map(Objects::toString).collect(Collectors.joining(", ")));
        }
        return evaluatedValues.stream().anyMatch(Boolean::booleanValue);
    }

    private boolean evaluateCustomFlag(@NonNull IToken identifierToken) {
        String identifierName = identifierToken.getText();
        this.conditionTokens.advancePosition(1);
        return this.config.isCustomFlagEnabled(identifierName);
    }

    private boolean evaluateTopOperator() throws EvaluationException {
        IToken operator = this.operators.pop();
        return switch (operator.getType()) {
            case ETokenType.NOT -> {
                if (!this.values.pop().booleanValue()) {
                    yield true;
                }
                yield false;
            }
            case ETokenType.ANDAND -> {
                boolean op1 = this.values.pop();
                boolean op2 = this.values.pop();
                if (op2 && op1) {
                    yield true;
                }
                yield false;
            }
            case ETokenType.OROR -> {
                boolean op1 = this.values.pop();
                boolean op2 = this.values.pop();
                if (op2 || op1) {
                    yield true;
                }
                yield false;
            }
            default -> throw new EvaluationException("Invalid operator: " + String.valueOf(operator.getType()) + " (" + operator.getText() + ")");
        };
    }

    private void evaluateOperatorsInCurrentParenthesisGroup() throws EvaluationException {
        while (!this.operators.isEmpty() && this.operators.peek().getType() != ETokenType.LPAREN) {
            this.values.push(this.evaluateTopOperator());
        }
    }

    private void evaluatePreviousOperatorsWithPrecedence(IToken currentToken) throws EvaluationException {
        while (!this.operators.isEmpty() && !this.values.isEmpty() && SwiftCompilationCondition.precedence(currentToken) <= SwiftCompilationCondition.precedence(this.operators.peek())) {
            this.values.push(this.evaluateTopOperator());
        }
    }

    private boolean evaluateInternal() throws EvaluationException {
        block7: while (!this.conditionTokens.isExhausted()) {
            IToken currentToken = this.conditionTokens.peekCurrent();
            switch (currentToken.getType()) {
                case BOOLEAN_LITERAL: {
                    this.values.push(SwiftCompilationCondition.evaluateLiteral(currentToken));
                    this.conditionTokens.advancePosition(1);
                    continue block7;
                }
                case IDENTIFIER: {
                    this.values.push(this.evaluateIdentifier(currentToken));
                    continue block7;
                }
                case LPAREN: {
                    this.operators.push(currentToken);
                    this.conditionTokens.advancePosition(1);
                    continue block7;
                }
                case RPAREN: {
                    this.evaluateOperatorsInCurrentParenthesisGroup();
                    this.operators.pop();
                    this.conditionTokens.advancePosition(1);
                    continue block7;
                }
                case NOT: 
                case ANDAND: 
                case OROR: {
                    this.evaluatePreviousOperatorsWithPrecedence(currentToken);
                    this.operators.push(currentToken);
                    this.conditionTokens.advancePosition(1);
                    continue block7;
                }
            }
            throw new EvaluationException("Unexpected token: " + String.valueOf(currentToken));
        }
        return this.completeEvaluation();
    }

    private boolean completeEvaluation() throws EvaluationException {
        while (!this.operators.isEmpty()) {
            this.values.push(this.evaluateTopOperator());
        }
        if (this.values.size() != 1) {
            throw new EvaluationException("Value stack not empty after completed evaluation; still contains %d elements".formatted(this.values.size()));
        }
        return this.values.pop();
    }

    public static boolean evaluate(@NonNull List<IToken> conditionTokens, @NonNull SwiftCompilerControlConfig config) throws EvaluationException {
        try {
            SwiftCompilationCondition condition = new SwiftCompilationCondition(config, conditionTokens);
            return condition.evaluateInternal();
        }
        catch (Exception e) {
            IToken firstToken = conditionTokens.get(0);
            throw new EvaluationException("Could not evaluate condition '%s' at '%s:%d' ".formatted(StringUtils.escapeChars((String)TokenStreamTextUtils.concatTokenTexts(conditionTokens, " "), (Map)StringUtils.ESCAPE_NEWLINE), firstToken.getOriginId(), firstToken.getLineNumber() + 1), e);
        }
    }
}

