/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.groovy;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.groovy.EGroovyShallowParserStates;
import eu.cqse.check.framework.shallowparser.languages.groovy.GroovyFieldRecognizer;
import eu.cqse.check.framework.shallowparser.languages.groovy.GroovyPrecedingEnumLiteralRecognizer;
import eu.cqse.check.framework.shallowparser.languages.groovy.GroovySkipToEndOfStatementRecognizer;
import eu.cqse.check.framework.shallowparser.languages.groovy.GroovySubExpressionRecognizer;

public class GroovyShallowParser
extends ShallowParserBase<EGroovyShallowParserStates> {
    private static final ITokenMatcher PRIMITIVE_DATATYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BOOLEAN, ETokenType.CHAR, ETokenType.SHORT, ETokenType.INT, ETokenType.LONG, ETokenType.FLOAT, ETokenType.DOUBLE});
    private static final ITokenMatcher LITERALS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BOOLEAN_LITERAL, ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL, ETokenType.NULL_LITERAL, ETokenType.STRING_LITERAL, ETokenType.CHARACTER_LITERAL});
    private static final ITokenMatcher ACCESS_MODIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PRIVATE, ETokenType.PROTECTED, ETokenType.PUBLIC});
    private static final ITokenMatcher TYPE_MODIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ABSTRACT, ETokenType.STATIC, ETokenType.FINAL, ETokenType.STRICTFP, ETokenType.SEALED}).or(new ITokenMatcher[]{ACCESS_MODIFIERS});
    private static final ITokenMatcher METHOD_MODIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ABSTRACT, ETokenType.STATIC, ETokenType.FINAL, ETokenType.NATIVE, ETokenType.SYNCHRONIZED, ETokenType.TRANSIENT, ETokenType.STRICTFP}).or(new ITokenMatcher[]{ACCESS_MODIFIERS});

    public GroovyShallowParser() {
        super(EGroovyShallowParserStates.class, EGroovyShallowParserStates.TOP_LEVEL);
        this.createMetaRules();
        this.createInitializerRules();
        this.createTypeRules();
        this.createFieldRules();
        this.createEnumLiteralRule();
        this.createMethodDefinitionRules();
        this.createConstructorDefinitionRule();
        this.createInExpressionRules();
        this.createLoopRules();
        this.createSwitchCaseRules();
        this.createContinuationRules();
        this.createStatementRule();
        this.createEmptyStatementRule();
    }

    private void createMetaRules() {
        this.createPackageRule();
        this.createImportRule();
        this.createAnnotationRule();
        this.createLabelRule();
    }

    private void createPackageRule() {
        this.inState(new EGroovyShallowParserStates[]{EGroovyShallowParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.PACKAGE}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).repeated(new ITokenMatcher[]{ETokenType.DOT, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.MULT})}).createNode(EShallowEntityType.META, "package", INameResolver.ofRange(0, -1)).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createImportRule() {
        this.inState(new EGroovyShallowParserStates[]{EGroovyShallowParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.IMPORT}).optional(new ITokenMatcher[]{ETokenType.STATIC}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).repeated(new ITokenMatcher[]{ETokenType.DOT, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.MULT})}).createNode(EShallowEntityType.META, "import", INameResolver.ofRange(0, -1)).optional(new ITokenMatcher[]{ETokenType.AS, ETokenType.IDENTIFIER}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createAnnotationRule() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.AT_OPERATOR, ETokenType.IDENTIFIER}).repeated(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, "annotation", INameResolver.ofRange(1, -1)).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).endNode();
    }

    private void createLabelRule() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.COLON}).createNode(EShallowEntityType.META, "label", INameResolver.ofIndex(-2)).endNode();
    }

    private void createInitializerRules() {
        this.inState(new EGroovyShallowParserStates[]{EGroovyShallowParserStates.IN_TYPE, EGroovyShallowParserStates.IN_ENUM_TYPE}).sequence(new ITokenMatcher[]{ETokenType.STATIC}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, "static initializer", "<sinit>").parseUntil(EGroovyShallowParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EGroovyShallowParserStates[]{EGroovyShallowParserStates.IN_TYPE, EGroovyShallowParserStates.IN_ENUM_TYPE}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, "non-static initializer", "<init>").parseUntil(EGroovyShallowParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createTypeRules() {
        this.createTypeRule(ETokenType.CLASS, "class", EGroovyShallowParserStates.IN_TYPE);
        this.createTypeRule(ETokenType.INTERFACE, "interface", EGroovyShallowParserStates.IN_TYPE);
        this.createTypeRule(ETokenType.RECORD, "record", EGroovyShallowParserStates.IN_TYPE);
        this.createTypeRule(ETokenType.ANNOTATION_INTERFACE, "annotation", EGroovyShallowParserStates.IN_TYPE);
        this.createTypeRule(ETokenType.TRAIT, "trait", EGroovyShallowParserStates.IN_TYPE);
        this.createTypeRule(ETokenType.ENUM, "enum", EGroovyShallowParserStates.IN_ENUM_TYPE);
    }

    private void createTypeRule(ETokenType type, String subTypeName, EGroovyShallowParserStates subState) {
        this.inState(new EGroovyShallowParserStates[]{EGroovyShallowParserStates.TOP_LEVEL, EGroovyShallowParserStates.IN_TYPE, EGroovyShallowParserStates.IN_ENUM_TYPE}).repeated(TYPE_MODIFIERS).sequence(new ITokenMatcher[]{type}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.TYPE, subTypeName, INameResolver.previousTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(subState).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createEnumLiteralRule() {
        RecognizerBase<EGroovyShallowParserStates> enumBase = this.inState(new EGroovyShallowParserStates[]{EGroovyShallowParserStates.IN_ENUM_TYPE}).preCondition(new GroovyPrecedingEnumLiteralRecognizer()).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.ATTRIBUTE, "enum literal", INameResolver.firstMatchedTokenText()).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, GroovyShallowParser.createSubExpressionRecognizer());
        enumBase.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGroovyShallowParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COMMA, ETokenType.SEMICOLON})).endNode();
        enumBase.optional(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COMMA, ETokenType.SEMICOLON})).endNode();
    }

    private void createMethodDefinitionRules() {
        this.createMethodDefinitionRulesInState(EGroovyShallowParserStates.TOP_LEVEL);
        this.createMethodDefinitionRulesInState(EGroovyShallowParserStates.IN_TYPE);
        this.createMethodDefinitionRulesInState(EGroovyShallowParserStates.IN_ENUM_TYPE);
    }

    private void createMethodDefinitionRulesInState(EGroovyShallowParserStates state) {
        ITokenMatcher returnTypes = PRIMITIVE_DATATYPES.or(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.VOID, ETokenType.DEF, ETokenType.IDENTIFIER})});
        RecognizerBase<EGroovyShallowParserStates> baseWithModifier = this.inState(new EGroovyShallowParserStates[]{state}).sequence(METHOD_MODIFIERS).repeated(METHOD_MODIFIERS).skipNested(ETokenType.LT, ETokenType.GT).sequence(returnTypes).repeated(new ITokenMatcher[]{ETokenType.DOT, returnTypes}).skipNested(ETokenType.LT, ETokenType.GT).skipWhile(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LBRACK, ETokenType.RBRACK}));
        GroovyShallowParser.endMethodDefinitionRule(baseWithModifier, state);
        RecognizerBase<EGroovyShallowParserStates> baseWithReturnType = this.inState(new EGroovyShallowParserStates[]{state}).repeated(METHOD_MODIFIERS).skipNested(ETokenType.LT, ETokenType.GT).sequence(returnTypes).repeated(new ITokenMatcher[]{ETokenType.DOT, returnTypes}).skipNested(ETokenType.LT, ETokenType.GT).skipWhile(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LBRACK, ETokenType.RBRACK}));
        GroovyShallowParser.endMethodDefinitionRule(baseWithReturnType, state);
        RecognizerBase<EGroovyShallowParserStates> baseWithoutReturnType = this.inState(new EGroovyShallowParserStates[]{state}).sequence(METHOD_MODIFIERS).repeated(METHOD_MODIFIERS).skipNested(ETokenType.LT, ETokenType.GT);
        GroovyShallowParser.endMethodDefinitionRule(baseWithoutReturnType, state);
    }

    private static void endMethodDefinitionRule(RecognizerBase<EGroovyShallowParserStates> base, EGroovyShallowParserStates state) {
        RecognizerBase<EGroovyShallowParserStates> methodDef = base.markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN);
        RecognizerBase<EGroovyShallowParserStates> throwsMethodDef = methodDef.sequence(new ITokenMatcher[]{ETokenType.THROWS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).repeated(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COMMA, ETokenType.DOT}), ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, "method", INameResolver.firstMatchedTokenText());
        throwsMethodDef.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGroovyShallowParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        methodDef.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, "method", INameResolver.firstMatchedTokenText()).parseUntil(EGroovyShallowParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        if (state == EGroovyShallowParserStates.IN_TYPE) {
            methodDef.createNode(EShallowEntityType.METHOD, "method", INameResolver.firstMatchedTokenText()).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
            throwsMethodDef.optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        }
    }

    private void createConstructorDefinitionRule() {
        this.inState(new EGroovyShallowParserStates[]{EGroovyShallowParserStates.IN_TYPE, EGroovyShallowParserStates.IN_ENUM_TYPE}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).createNode(EShallowEntityType.METHOD, "constructor", INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGroovyShallowParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createLoopRules() {
        RecognizerBase<EGroovyShallowParserStates> loopBase = this.inState(new EGroovyShallowParserStates[]{EGroovyShallowParserStates.IN_METHOD, EGroovyShallowParserStates.TOP_LEVEL}).markStart().sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.FOR, ETokenType.WHILE})).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, GroovyShallowParser.createSubExpressionRecognizer());
        loopBase.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGroovyShallowParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        loopBase.parseOnce(EGroovyShallowParserStates.IN_METHOD).endNode();
    }

    private void createSwitchCaseRules() {
        GroovyShallowParser.endSwitchNode(this.inState(new EGroovyShallowParserStates[]{EGroovyShallowParserStates.TOP_LEVEL, EGroovyShallowParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.SWITCH}).createNode(EShallowEntityType.STATEMENT, "switch"));
        GroovyShallowParser.endSwitchNode(this.inState(new EGroovyShallowParserStates[]{EGroovyShallowParserStates.IN_EXPRESSION}).sequence(new ITokenMatcher[]{ETokenType.SWITCH}).createNode(EShallowEntityType.STATEMENT, "switch expression"));
        this.inState(new EGroovyShallowParserStates[]{EGroovyShallowParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.CASE}).sequenceBefore(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.META, "case").parseOnce(EGroovyShallowParserStates.IN_EXPRESSION).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COLON, ETokenType.ARROW})).endNode();
        this.inState(new EGroovyShallowParserStates[]{EGroovyShallowParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.CASE}).createNode(EShallowEntityType.META, "case").skipAfterWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COLON, ETokenType.ARROW}), ETokenType.LBRACK, ETokenType.RBRACK).endNode();
        this.inState(new EGroovyShallowParserStates[]{EGroovyShallowParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.DEFAULT}).createNode(EShallowEntityType.META, "default").sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COLON, ETokenType.ARROW})).endNode();
        this.inState(new EGroovyShallowParserStates[]{EGroovyShallowParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGroovyShallowParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE});
    }

    private static void endSwitchNode(RecognizerBase<EGroovyShallowParserStates> switchNode) {
        switchNode.skipNested(ETokenType.LPAREN, ETokenType.RPAREN, GroovyShallowParser.createSubExpressionRecognizer()).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGroovyShallowParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createContinuationRules() {
        this.createRuleWithContinuation(ETokenType.IF, ETokenType.ELSE, ETokenType.ELSE, ETokenType.IF);
        this.createRuleWithContinuation(ETokenType.TRY, ETokenType.FINALLY, ETokenType.CATCH);
    }

    private void createRuleWithContinuation(ETokenType first, ETokenType last, ETokenType ... middle) {
        RecognizerBase<EGroovyShallowParserStates> baseMid = this.inState(new EGroovyShallowParserStates[]{EGroovyShallowParserStates.TOP_LEVEL, EGroovyShallowParserStates.IN_METHOD}).sequence((ITokenMatcher[])middle);
        RecognizerBase<EGroovyShallowParserStates> baseFirstLast = this.inState(new EGroovyShallowParserStates[]{EGroovyShallowParserStates.TOP_LEVEL, EGroovyShallowParserStates.IN_METHOD}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{first, last}));
        ITokenMatcher continuationTokens = last.or(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])middle)});
        this.endContinuationNode(baseMid, continuationTokens);
        this.endContinuationNode(baseFirstLast, continuationTokens);
    }

    private void endContinuationNode(RecognizerBase<EGroovyShallowParserStates> baseRecognizer, ITokenMatcher continuationTokens) {
        baseRecognizer = baseRecognizer.createNode(EShallowEntityType.STATEMENT, INameResolver.ofRange(0, -1)).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, GroovyShallowParser.createSubExpressionRecognizer());
        RecognizerBase<EGroovyShallowParserStates> baseMultipleStatement = baseRecognizer.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGroovyShallowParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE});
        RecognizerBase<EGroovyShallowParserStates> baseSingleStatement = baseRecognizer.parseOnce(EGroovyShallowParserStates.IN_METHOD);
        this.endWithPossibleContinuation(baseMultipleStatement, continuationTokens);
        this.endWithPossibleContinuation(baseSingleStatement, continuationTokens);
    }

    private void createFieldRules() {
        this.createFieldRules(EShallowEntityType.ATTRIBUTE, "attribute", EGroovyShallowParserStates.IN_TYPE, EGroovyShallowParserStates.IN_ENUM_TYPE);
        this.createFieldRules(EShallowEntityType.STATEMENT, "local variable", EGroovyShallowParserStates.TOP_LEVEL, EGroovyShallowParserStates.IN_METHOD);
    }

    private void createFieldRules(EShallowEntityType shallowEntityType, String subTypeName, EGroovyShallowParserStates ... states) {
        RecognizerBase<EGroovyShallowParserStates> withDatatype = this.fieldWithDataType(states).preCondition(GroovyShallowParser.createFieldRecognizer()).createNode(shallowEntityType, subTypeName, INameResolver.previousTokenText());
        RecognizerBase<EGroovyShallowParserStates> withModifier = this.inState(states).sequence(TYPE_MODIFIERS).repeated(TYPE_MODIFIERS).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).preCondition(GroovyShallowParser.createFieldRecognizer()).createNode(shallowEntityType, subTypeName, INameResolver.previousTokenText());
        RecognizerBase<EGroovyShallowParserStates> multipleAssignment = this.inState(states).sequence(new ITokenMatcher[]{ETokenType.DEF}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).preCondition(GroovyShallowParser.createFieldRecognizer()).createNode(shallowEntityType, subTypeName, INameResolver.ofRange(1, -1));
        GroovyShallowParser.endFieldRule(withDatatype);
        GroovyShallowParser.endFieldRule(withModifier);
        GroovyShallowParser.endFieldRule(multipleAssignment);
    }

    private RecognizerBase<EGroovyShallowParserStates> fieldWithDataType(EGroovyShallowParserStates ... states) {
        ITokenMatcher datatypes = PRIMITIVE_DATATYPES.or(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.DEF, ETokenType.THIS})});
        return this.inState(states).repeated(TYPE_MODIFIERS).sequence(datatypes).repeated(new ITokenMatcher[]{ETokenType.DOT, datatypes}).skipNested(ETokenType.LT, ETokenType.GT).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER});
    }

    private static RecognizerBase<EGroovyShallowParserStates> createFieldRecognizer() {
        return new GroovyFieldRecognizer();
    }

    private static void endFieldRule(RecognizerBase<EGroovyShallowParserStates> fieldNode) {
        fieldNode.sequence(new ITokenMatcher[]{ETokenType.EQ}).sequenceBefore(new ITokenMatcher[]{ETokenType.SWITCH}).parseOnce(EGroovyShallowParserStates.IN_EXPRESSION).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        GroovyShallowParser.skipToEndOfStatement(fieldNode);
    }

    private void createStatementRule() {
        ITokenMatcher statementStartTokens = PRIMITIVE_DATATYPES.or(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.NEW, ETokenType.RETURN, ETokenType.THIS, ETokenType.CONTINUE, ETokenType.BREAK, ETokenType.GOTO, ETokenType.THROW, ETokenType.SUPER, ETokenType.ASSERT, ETokenType.MINUS, ETokenType.PLUSPLUS, ETokenType.MINUSMINUS, ETokenType.YIELD}), LITERALS});
        RecognizerBase<EGroovyShallowParserStates> base = this.inState(new EGroovyShallowParserStates[]{EGroovyShallowParserStates.IN_METHOD, EGroovyShallowParserStates.TOP_LEVEL}).sequenceBefore(statementStartTokens).createNode(EShallowEntityType.STATEMENT, "simple statement", INameResolver.firstMatchedTokenText());
        base.sequence(new ITokenMatcher[]{ETokenType.RETURN}).sequenceBefore(new ITokenMatcher[]{ETokenType.SWITCH}).parseOnce(EGroovyShallowParserStates.IN_EXPRESSION).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        GroovyShallowParser.skipToEndOfStatement(base, true);
        RecognizerBase<EGroovyShallowParserStates> inParenthesis = this.inState(new EGroovyShallowParserStates[]{EGroovyShallowParserStates.IN_METHOD, EGroovyShallowParserStates.TOP_LEVEL}).sequenceBefore(new ITokenMatcher[]{ETokenType.LPAREN}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.STATEMENT, "simple statement", INameResolver.ofRange(0, -1));
        GroovyShallowParser.skipToEndOfStatement(inParenthesis);
        RecognizerBase<EGroovyShallowParserStates> inBrackets = this.inState(new EGroovyShallowParserStates[]{EGroovyShallowParserStates.IN_METHOD, EGroovyShallowParserStates.TOP_LEVEL}).sequenceBefore(new ITokenMatcher[]{ETokenType.LBRACK}).createNode(EShallowEntityType.STATEMENT, "simple statement", INameResolver.firstMatchedTokenText()).skipNested(ETokenType.LBRACK, ETokenType.RBRACK, GroovyShallowParser.createSubExpressionRecognizer());
        GroovyShallowParser.skipToEndOfStatement(inBrackets);
    }

    private void createEmptyStatementRule() {
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.STATEMENT, "empty statement").endNode();
    }

    private static void skipToEndOfStatement(RecognizerBase<EGroovyShallowParserStates> base) {
        GroovyShallowParser.skipToEndOfStatement(base, false);
    }

    private static void skipToEndOfStatement(RecognizerBase<EGroovyShallowParserStates> base, boolean forceMatch) {
        GroovySkipToEndOfStatementRecognizer recognizer = new GroovySkipToEndOfStatementRecognizer();
        recognizer.setForceMatch(forceMatch);
        base.subRecognizer(recognizer, 0, 1).endNode();
    }

    private void createInExpressionRules() {
        this.inState(new EGroovyShallowParserStates[]{EGroovyShallowParserStates.IN_EXPRESSION}).sequence(new ITokenMatcher[]{ETokenType.NEW, ETokenType.IDENTIFIER}).repeated(new ITokenMatcher[]{ETokenType.DOT, ETokenType.IDENTIFIER}).skipNested(ETokenType.LT, ETokenType.GT).createNode(EShallowEntityType.TYPE, "anonymous class", INameResolver.secondMatchedTokenText()).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, GroovyShallowParser.createSubExpressionRecognizer()).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGroovyShallowParserStates.IN_TYPE).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        RecognizerBase<EGroovyShallowParserStates> closureBase = this.inState(new EGroovyShallowParserStates[]{EGroovyShallowParserStates.IN_EXPRESSION}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.STATEMENT, "anonymous function");
        closureBase.skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ARROW, ETokenType.LBRACE})).sequence(new ITokenMatcher[]{ETokenType.ARROW}).parseUntil(EGroovyShallowParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        closureBase.parseUntil(EGroovyShallowParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private static RecognizerBase<EGroovyShallowParserStates> createSubExpressionRecognizer() {
        return new GroovySubExpressionRecognizer();
    }
}

