/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.matlab;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;

public class MatlabShallowParser
extends ShallowParserBase<EMatlabParserStates> {
    private static final ITokenMatcher STATEMENT_SEPARATORS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EOL, ETokenType.SEMICOLON, ETokenType.COMMA});
    private static final EMatlabParserStates[] STATEMENT_STATES = new EMatlabParserStates[]{EMatlabParserStates.TOP_LEVEL, EMatlabParserStates.IN_METHOD};

    public MatlabShallowParser() {
        super(EMatlabParserStates.class, EMatlabParserStates.TOP_LEVEL);
        this.createTopLevelRules();
        this.createInClassDefRules();
        this.createInMethodDefRules();
        this.createInPropertiesRules();
        this.createInEventsRules();
        this.createInEnumerationRules();
        this.createInMethodsRules();
        this.createInArgumentsRules();
        this.createStatementRules();
    }

    private void createTopLevelRules() {
        this.inState(new EMatlabParserStates[]{EMatlabParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.CLASSDEF}).skipAfterWithNesting((ITokenMatcher)ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.TYPE, "class", INameResolver.previousTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.EOL}).parseUntil(EMatlabParserStates.IN_CLASSDEF).sequence(new ITokenMatcher[]{ETokenType.END}).endNode();
    }

    private void createInClassDefRules() {
        this.createInClassDefSectionRule(ETokenType.PROPERTIES, EMatlabParserStates.IN_PROPERTIES);
        this.createInClassDefSectionRule(ETokenType.METHODS, EMatlabParserStates.IN_METHODS);
        this.createInClassDefSectionRule(ETokenType.EVENTS, EMatlabParserStates.IN_EVENTS);
        this.inState(new EMatlabParserStates[]{EMatlabParserStates.IN_CLASSDEF}).sequence(new ITokenMatcher[]{ETokenType.ENUMERATION, ETokenType.EOL}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).parseUntil(EMatlabParserStates.IN_ENUMERATION).sequence(new ITokenMatcher[]{ETokenType.END}).endNode();
    }

    private void createInMethodDefRules() {
        this.inState(new EMatlabParserStates[]{EMatlabParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.ARGUMENTS}).skipAfterWithNesting((ITokenMatcher)ETokenType.EOL, ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).parseUntil(EMatlabParserStates.IN_ARGUMENTS).sequence(new ITokenMatcher[]{ETokenType.END}).endNode();
    }

    private void createInClassDefSectionRule(ETokenType startTokenType, EMatlabParserStates subState) {
        this.inState(new EMatlabParserStates[]{EMatlabParserStates.IN_CLASSDEF}).sequence(new ITokenMatcher[]{startTokenType}).skipAfterWithNesting((ITokenMatcher)ETokenType.EOL, ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).parseUntil(subState).sequence(new ITokenMatcher[]{ETokenType.END}).endNode();
    }

    private void createInPropertiesRules() {
        this.inState(new EMatlabParserStates[]{EMatlabParserStates.IN_PROPERTIES}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.ATTRIBUTE, "attribute", INameResolver.firstMatchedTokenText()).skipAfter(STATEMENT_SEPARATORS).endNode();
    }

    private void createInEventsRules() {
        this.inState(new EMatlabParserStates[]{EMatlabParserStates.IN_EVENTS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.ATTRIBUTE, INameResolver.firstMatchedTokenText()).sequence(new ITokenMatcher[]{ETokenType.EOL}).endNode();
    }

    private void createInEnumerationRules() {
        this.inState(new EMatlabParserStates[]{EMatlabParserStates.IN_ENUMERATION}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.ATTRIBUTE, "enum-literal", INameResolver.firstMatchedTokenText()).skipAfterWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COMMA, ETokenType.EOL}), ETokenType.LPAREN, ETokenType.RPAREN).endNode();
    }

    private void createInArgumentsRules() {
        this.inState(new EMatlabParserStates[]{EMatlabParserStates.IN_ARGUMENTS}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.ATTRIBUTE, "attribute", INameResolver.firstMatchedTokenText()).skipAfter(STATEMENT_SEPARATORS).endNode();
    }

    private void createInMethodsRules() {
        RecognizerBase<EMatlabParserStates> functionAlternative = this.inState(new EMatlabParserStates[]{EMatlabParserStates.TOP_LEVEL, EMatlabParserStates.IN_METHOD, EMatlabParserStates.IN_METHODS}).sequence(new ITokenMatcher[]{ETokenType.FUNCTION});
        MatlabShallowParser.continueMethodHeadRule(functionAlternative.sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.EQ}), true);
        MatlabShallowParser.continueMethodHeadRule(functionAlternative, true);
        MatlabShallowParser.continueMethodHeadRule(functionAlternative.skipAfterWithNesting((ITokenMatcher)ETokenType.EQ, ETokenType.LBRACK, ETokenType.RBRACK), true);
        MatlabShallowParser.continueMethodHeadRule(this.inState(new EMatlabParserStates[]{EMatlabParserStates.IN_METHODS}), false);
    }

    private static void continueMethodHeadRule(RecognizerBase<EMatlabParserStates> functionRecognizer, boolean isDefinition) {
        String subtype = "function declaration";
        if (isDefinition) {
            subtype = "function";
        }
        functionRecognizer = functionRecognizer.sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.METHOD, subtype, INameResolver.previousTokenText()).skipAfterWithNesting((ITokenMatcher)ETokenType.EOL, ETokenType.LPAREN, ETokenType.RPAREN);
        if (isDefinition) {
            functionRecognizer = functionRecognizer.parseUntilOrEof(EMatlabParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.END});
        }
        functionRecognizer.endNode();
    }

    private void createStatementRules() {
        this.createBlockRulesWithContinuation(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IF, ETokenType.ELSEIF, ETokenType.ELSE}), ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.ELSEIF, ETokenType.ELSE}));
        this.createBlockRulesWithContinuation(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.TRY, ETokenType.CATCH}), (ITokenMatcher)ETokenType.CATCH);
        this.createLoopRules();
        this.createSwitchCaseRules();
        this.createShellEscapeRules();
        this.createSimpleStatementRule();
    }

    private void createBlockRulesWithContinuation(ITokenMatcher startTokens, ITokenMatcher continuationTokens) {
        RecognizerBase<EMatlabParserStates> alternative = this.inState(STATEMENT_STATES).sequence(startTokens).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(STATEMENT_SEPARATORS).parseUntil(EMatlabParserStates.IN_METHOD);
        alternative.sequence(new ITokenMatcher[]{ETokenType.END}).endNode();
        alternative.sequenceBefore(continuationTokens).endNodeWithContinuation();
    }

    private void createLoopRules() {
        this.inState(STATEMENT_STATES).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.FOR, ETokenType.PARFOR, ETokenType.WHILE})).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(STATEMENT_SEPARATORS).parseUntil(EMatlabParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.END}).endNode();
    }

    private void createSwitchCaseRules() {
        this.inState(STATEMENT_STATES).sequence(new ITokenMatcher[]{ETokenType.SWITCH}).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.EOL}).parseUntil(EMatlabParserStates.IN_SWITCH).sequence(new ITokenMatcher[]{ETokenType.END}).endNode();
        this.inState(new EMatlabParserStates[]{EMatlabParserStates.IN_SWITCH}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CASE, ETokenType.OTHERWISE})).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.EOL}).parseUntil(EMatlabParserStates.IN_METHOD).sequenceBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CASE, ETokenType.OTHERWISE, ETokenType.END})).endNode();
    }

    private void createShellEscapeRules() {
        this.inState(STATEMENT_STATES).sequence(new ITokenMatcher[]{ETokenType.EXCLAMATION}).createNode(EShallowEntityType.STATEMENT, "shell-escape").skipAfter(new ITokenMatcher[]{ETokenType.EOL}).endNode();
    }

    private void createSimpleStatementRule() {
        ITokenMatcher simpleStatementMatcher = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.BREAK, ETokenType.CONTINUE, ETokenType.RETURN, ETokenType.LBRACK, ETokenType.PERSISTENT, ETokenType.GLOBAL});
        this.inState(STATEMENT_STATES).sequence(simpleStatementMatcher).createNode(EShallowEntityType.STATEMENT, "simple-statement", INameResolver.firstMatchedTokenText()).skipAfter(STATEMENT_SEPARATORS).endNode();
    }

    public static enum EMatlabParserStates {
        TOP_LEVEL,
        IN_CLASSDEF,
        IN_PROPERTIES,
        IN_EVENTS,
        IN_ENUMERATION,
        IN_METHODS,
        IN_METHOD,
        IN_ARGUMENTS,
        IN_SWITCH;

    }
}

