/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.conqat.lib.commons.collections.UnmodifiableIterator;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.jspecify.annotations.NonNull;

final class UnmodifiableSetImpl<E>
implements UnmodifiableSet<E> {
    private static final long serialVersionUID = 1L;
    private final Set<E> set;

    public UnmodifiableSetImpl(Set<E> set) {
        this.set = Collections.unmodifiableSet(set);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public Object @NonNull [] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T> T @NonNull [] toArray(T @NonNull [] a) {
        return this.set.toArray(a);
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public @NonNull UnmodifiableIterator<E> iterator() {
        return UnmodifiableIterator.of(this.set.iterator());
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.set.spliterator();
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        return this.set.toArray(generator);
    }

    @Override
    public Stream<E> stream() {
        return this.set.stream();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.set.parallelStream();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.set.forEach(action);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UnmodifiableSetImpl) {
            UnmodifiableSetImpl that = (UnmodifiableSetImpl)o;
            return this.set.equals(that.set);
        }
        return this.set.equals(o);
    }

    @Override
    public int hashCode() {
        return this.set.hashCode();
    }

    public String toString() {
        return this.set.toString();
    }
}

