/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.region;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class SimpleRegion
implements Comparable<SimpleRegion>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String START_PROPERTY = "start";
    protected static final String END_PROPERTY = "end";
    public static final Comparator<SimpleRegion> START_AND_END_COMPARATOR = Comparator.comparing(SimpleRegion::getStart).thenComparing(SimpleRegion::getEnd);
    @JsonProperty(value="start")
    private final int start;
    @JsonProperty(value="end")
    private final int end;

    public SimpleRegion(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public boolean containsPosition(int position) {
        return this.start <= position && this.end >= position;
    }

    public boolean overlaps(SimpleRegion r) {
        if (r.start < this.start) {
            return r.overlaps(this);
        }
        return this.start <= r.start && this.end >= r.start;
    }

    public boolean adjacent(SimpleRegion r) {
        if (r.start < this.start) {
            return r.adjacent(this);
        }
        return this.end + 1 == r.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getStart() {
        return this.start;
    }

    public int getLength() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.end - this.start + 1;
    }

    public boolean isEmpty() {
        return this.end < this.start;
    }

    public String toString() {
        return "[" + this.start + "-" + this.end + "]";
    }

    @Override
    public int compareTo(SimpleRegion other) {
        return Integer.compare(this.start, other.start);
    }

    public boolean equalsStartEnd(SimpleRegion other) {
        return this.start == other.start && this.end == other.end;
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleRegion;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleRegion)) {
            return false;
        }
        SimpleRegion that = (SimpleRegion)other;
        return that.canEqual(this) && this.equalsStartEnd(that);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }
}

