/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.clang;

import eu.cqse.clang.CXChildVisitResult;
import eu.cqse.clang.CXCursor;
import eu.cqse.clang.CXSourceLocation;
import eu.cqse.clang.CXToken;
import eu.cqse.clang.CXUnsavedFile;
import eu.cqse.clang.Clang;
import eu.cqse.clang.ClangBinding;
import eu.cqse.clang.ClangJNI;
import eu.cqse.clang.ClangJniLoader;
import eu.cqse.clang.ClangSpellingLocationProperties;
import eu.cqse.clang.ClangTidyError;
import eu.cqse.clang.ClangTidyFile;
import eu.cqse.clang.IClangCursorVisitor;
import eu.cqse.clang.SWIGTYPE_p_CXTranslationUnitImpl;
import eu.cqse.clang.SWIGTYPE_p_void;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Main {
    private static final String CODE = "#include \"my-header.h\"\n#include <stdio.h>\n\nint Foo::add (int a, int b) {\n  for (int i = 0; i < 10; ++i);\n    printf (\"Hello world\\n\");\n  return a+b; \n}\n\n";
    private static final String HEADER = "#ifndef MY_HEADER\n#define MY_HEADER\n\nclass Foo {\npublic: \n  int add (int a, int b);\n};\n\n#endif // MY_HEADER\n";

    public static void main(String[] stringArray) throws IOException {
        ClangJniLoader.ensureLoaded();
        Main.parseCode();
        Main.runClangTidy();
    }

    private static void parseCode() {
        System.out.println("## Test code parsing");
        CXUnsavedFile cXUnsavedFile = new CXUnsavedFile();
        cXUnsavedFile.setFilename("/foo/code.cpp");
        cXUnsavedFile.setContents(CODE);
        cXUnsavedFile.setLength(CODE.length());
        CXUnsavedFile cXUnsavedFile2 = new CXUnsavedFile();
        cXUnsavedFile2.setFilename("/foo/my-header.h");
        cXUnsavedFile2.setContents(HEADER);
        cXUnsavedFile2.setLength(HEADER.length());
        Main.parseFiles(cXUnsavedFile, cXUnsavedFile2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseFiles(CXUnsavedFile ... cXUnsavedFileArray) {
        SWIGTYPE_p_void sWIGTYPE_p_void = Clang.clang_createIndex(0, 0);
        try {
            SWIGTYPE_p_CXTranslationUnitImpl sWIGTYPE_p_CXTranslationUnitImpl = Clang.clang_parseTranslationUnit(sWIGTYPE_p_void, cXUnsavedFileArray[0].getFilename(), null, 0, cXUnsavedFileArray, cXUnsavedFileArray.length, ClangJNI.CXTranslationUnit_KeepGoing_get());
            try {
                CXCursor cXCursor = Clang.clang_getTranslationUnitCursor(sWIGTYPE_p_CXTranslationUnitImpl);
                try {
                    ClangBinding.visitChildren(cXCursor, new PrintVisitor(sWIGTYPE_p_CXTranslationUnitImpl));
                }
                finally {
                    cXCursor.delete();
                }
            }
            finally {
                Clang.clang_disposeTranslationUnit(sWIGTYPE_p_CXTranslationUnitImpl);
            }
        }
        finally {
            Clang.clang_disposeIndex(sWIGTYPE_p_void);
        }
    }

    private static void runClangTidy() {
        System.out.println("\n## All clang-tidy checks found: ");
        ClangBinding.getAllClangTidyChecks().stream().map(string -> "  - " + string).forEach(System.out::println);
        System.out.println("\n## All clang-tidy options found: ");
        ClangBinding.getAllClangTidyCheckOptions().forEach((string, string2) -> System.out.println("  " + string + " -> " + string2));
        System.out.println("\n## clang-tidy test run: ");
        List<ClangTidyFile> list = Arrays.asList(new ClangTidyFile("/virtual/code.cc", CODE), new ClangTidyFile("/virtual/my-header.h", HEADER));
        List<ClangTidyError> list2 = ClangBinding.runClangTidy(list, "*", Collections.emptyList(), ClangBinding.getAllClangTidyCheckOptions(), true);
        for (ClangTidyError clangTidyError : list2) {
            System.out.println(clangTidyError.getPath() + ":" + clangTidyError.getOffset() + ":" + clangTidyError.getCheckName() + ":" + clangTidyError.getMessage());
        }
    }

    private static class PrintVisitor
    implements IClangCursorVisitor {
        private final SWIGTYPE_p_CXTranslationUnitImpl translationUnit;
        private final int level;

        public PrintVisitor(SWIGTYPE_p_CXTranslationUnitImpl sWIGTYPE_p_CXTranslationUnitImpl) {
            this(sWIGTYPE_p_CXTranslationUnitImpl, 0);
        }

        public PrintVisitor(SWIGTYPE_p_CXTranslationUnitImpl sWIGTYPE_p_CXTranslationUnitImpl, int n) {
            this.translationUnit = sWIGTYPE_p_CXTranslationUnitImpl;
            this.level = n;
        }

        @Override
        public CXChildVisitResult visit(CXCursor cXCursor, CXCursor cXCursor2) {
            for (int i = 0; i < this.level; ++i) {
                System.out.print("    ");
            }
            this.print(cXCursor);
            ClangBinding.visitChildren(cXCursor, new PrintVisitor(this.translationUnit, this.level + 1));
            return CXChildVisitResult.CXChildVisit_Continue;
        }

        public void print(CXCursor cXCursor) {
            CXSourceLocation cXSourceLocation = Clang.clang_getCursorLocation(cXCursor);
            ClangSpellingLocationProperties clangSpellingLocationProperties = ClangBinding.getSpellingLocationProperties(cXSourceLocation);
            long l = clangSpellingLocationProperties.getLine();
            String string = Clang.clang_getCString(Clang.clang_getCursorDisplayName(cXCursor));
            String string2 = Clang.clang_getCursorKind(cXCursor).toString();
            String string3 = Clang.clang_getCursorType(cXCursor).getKind().toString();
            String string4 = Clang.clang_getCString(Clang.clang_getTypeSpelling(Clang.clang_getCursorType(cXCursor)));
            String string5 = Clang.clang_getCString(Clang.clang_getCursorSpelling(cXCursor));
            CXToken cXToken = Clang.clang_getToken(this.translationUnit, Clang.clang_getCursorLocation(cXCursor));
            String string6 = "token is null";
            if (cXToken != null) {
                string6 = Clang.clang_getCString(Clang.clang_getTokenSpelling(this.translationUnit, cXToken));
            }
            System.out.println(clangSpellingLocationProperties.getFile() + ":" + l + " name:" + string + " kind:" + string2 + " type:" + string4 + "/" + string3 + " spelling:" + string5 + " tokenSpelling: " + string6);
        }
    }
}

