/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.authenticate;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationEntityNotFoundException;
import com.teamscale.core.authenticate.base.AuthenticationToolClientException;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.AuthenticationToolUtils;
import com.teamscale.core.authenticate.base.IAuthenticationToolProvider;
import com.teamscale.core.authenticate.base.IImportGroupsStrategy;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/auth/import/groups")
public class ImportGroupsService
extends ApiBase {
    @POST
    @Operation(summary="Import group", description="Imports all users of one group from a remote server. Returns the list of imported user names.", responses={@ApiResponse(responseCode="404", description="The given server or group could not be found"), @ApiResponse(responseCode="500", description="The group already exists")}, tags={"Users", "Groups"})
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_USERS, EGlobalPermission.CREATE_GROUPS})
    @Path(value="{groupName}")
    public List<String> importGroup(@Parameter(description="The name of the group that should be imported.") @PathParam(value="groupName") String groupName, @Parameter(description="The name of the remote server.", required=true) @QueryParam(value="server-name") String serverName, @Parameter(description="The type of the remote server (e.g. ldap or crowd).", required=true) @QueryParam(value="server-type") EAuthenticationTool serverType) throws StorageException, AuthenticationToolException {
        if (this.openGlobalIndex(UserGroupIndex.class).getUserGroup(groupName) != null) {
            throw new BadRequestException("Group '" + groupName + "' already exists. Cannot import existing groups!");
        }
        try {
            IAuthenticationToolProvider toolProvider = AuthenticationToolUtils.getProvider((EAuthenticationTool)serverType, (GlobalStorageSystem)this.getGlobalStorageSystem(), (IMessageBroker)this.serviceInfo.getMessageBroker());
            IImportGroupsStrategy groupImportStrategy = toolProvider.createImportGroupsStrategy(serverName);
            List users = groupImportStrategy.importGroup(groupName);
            this.getPermissions().createPermissionModifier().makeCurrentUserOwner(EBasicPermissionScope.GROUPS, groupName);
            return users;
        }
        catch (AuthenticationEntityNotFoundException e) {
            throw new NotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (AuthenticationToolClientException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }
}

