/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.commit_trees.debug;

import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.ICommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.base.debug.DebugDumpServiceBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/projects/{project}/commit-trees/debug/commit-tree")
public class DebugCommitTreeDumpService
extends DebugDumpServiceBase {
    private static final String XDOT_PARAMETER_DESCRIPTION = "If the xdot parameter is true, the service returns the commit trees as an xdot graph. Otherwise it returns a plain text.";
    private static final String REPOSITORY_ID_PARAMETER_DESCRIPTION = "When provided will only dump the commit trees for the given repository, instead of all repository trees.";
    private static final String REPOSITORY_ID_PARAMETER_NAME = "repository-id";
    private String repositoryId = null;

    @GET
    @Operation(summary="Get commit trees", description="Returns the commit trees for a project.", tags={"Debugging"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Produces(value={"text/plain"})
    public String getDumpCommitTree(@Parameter(description="If the xdot parameter is true, the service returns the commit trees as an xdot graph. Otherwise it returns a plain text.") @QueryParam(value="xdot") boolean isXdotGraph, @Parameter(description="When provided will only dump the commit trees for the given repository, instead of all repository trees.") @QueryParam(value="repository-id") String repositoryId) throws StorageException {
        this.xdotGraph = isXdotGraph;
        this.repositoryId = repositoryId;
        return super.getDebugDumpResults();
    }

    @Override
    protected void generateDump(PrintWriter writer) throws StorageException {
        DebugCommitTreeDumpService.generateDump((ProjectStorageSystem)this.getProjectStorageSystem(), this.xdotGraph, writer, this.repositoryId);
    }

    public static void generateDump(ProjectStorageSystem projectStorageSystem, boolean xdotGraph, PrintWriter writer, String repositoryId) throws StorageException {
        CommitTreeIndex.listCommitTrees((ProjectStorageSystem)projectStorageSystem).forEach((storeName, commitTree) -> {
            if (!StringUtils.isEmpty((String)repositoryId) && !storeName.contains(repositoryId)) {
                return;
            }
            if (xdotGraph) {
                DebugCommitTreeDumpService.dumpXdotCommitTree(writer, commitTree, storeName);
            } else {
                DebugCommitTreeDumpService.dumpCommitTree(writer, commitTree, storeName);
            }
        });
    }

    private static void dumpXdotCommitTree(PrintWriter writer, ICommitTree tree, String storeName) {
        HashSet<String> edges = new HashSet<String>();
        for (ICommitTreeNode node : tree.getAllNodes()) {
            DebugCommitTreeDumpService.addEdges(edges, node);
        }
        writer.println("digraph \"" + storeName + "\" {");
        for (String edge : edges) {
            writer.println(edge);
        }
        writer.println("}");
    }

    private static void addEdges(Set<String> edges, ICommitTreeNode node) {
        for (ICommitTreeNode parent : node.getParents()) {
            edges.add("\"" + String.valueOf(parent) + "\" -> \"" + String.valueOf(node) + "\"");
        }
    }

    private static void dumpCommitTree(PrintWriter writer, ICommitTree tree, String storeName) {
        writer.println("Commit Tree for Index " + storeName);
        writer.println("========================");
        writer.println();
        tree.dumpCommitTree(writer);
        writer.println();
    }
}

