/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.commits;

import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;

public class RepositoryLogRangeServiceQueryOptions {
    public static final String START_PARAMETER_NAME = "start";
    public static final String END_PARAMETER_NAME = "end";
    public static final String INCLUDE_BOUNDS_PARAMETER_NAME = "include-bounds";
    @Parameter(description="Start timestamp to return repository log entries after.")
    @QueryParam(value="start")
    @DefaultValue(value="-1")
    private long startTimestampParameter;
    @Parameter(description="End timestamp to return repository log entries before.")
    @QueryParam(value="end")
    @DefaultValue(value="-1")
    private long endTimestampParameter;
    @Parameter(description="Whether or not commits for the timestamps from the start and/or end commit are included.")
    @QueryParam(value="include-bounds")
    private boolean includeBounds;
    @Parameter(description="The amount of repository logs returned when at least one of the commit parameters is omitted.")
    @QueryParam(value="entry-count")
    @DefaultValue(value="10")
    private int entryCount;
    @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon. Only log entries from commits merged into the given branch up to the given point will be considered when the start and end timestamps are evaluated.")
    @QueryParam(value="t")
    private UnresolvedCommitDescriptor commitParameter;
    @Parameter(description="Controls whether only repository log entries are returned where the current user was the committer.")
    @QueryParam(value="privacy-aware")
    private boolean isPrivacyAware;

    public long getStartTimestampParameter() {
        return this.startTimestampParameter;
    }

    public long getEndTimestampParameter() {
        return this.endTimestampParameter;
    }

    public boolean isIncludeBounds() {
        return this.includeBounds;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public UnresolvedCommitDescriptor getCommitParameter() {
        return this.commitParameter;
    }

    public boolean getIsPrivacyAware() {
        return this.isPrivacyAware;
    }
}

