/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.event_announcement;

import com.google.common.base.Preconditions;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.event_announcement.EventAnnouncement;
import com.teamscale.index.event_announcement.EventAnnouncementIndex;
import com.teamscale.index.user.UserEventAnnouncementPreferencesIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/event-announcement")
public class EventAnnouncementService
extends ApiBase {
    @GET
    @Path(value="events")
    @Operation(summary="Get all events", description="Returns the list of all available event announcements.", tags={"Event Announcement"})
    @RequiresNoPermission
    public List<EventAnnouncement> getEventAnnouncements() throws StorageException {
        return this.getEventAnnouncementIndex().getEventAnnouncements();
    }

    @GET
    @Path(value="unused-id")
    @Operation(summary="Get unused ID", description="Returns a valid event ID that is unused so far.", tags={"Event Announcement"})
    @RequiresNoPermission
    public String getUnusedEventId() throws StorageException {
        return this.getEventAnnouncementIndex().generateUnusedEventId();
    }

    @PUT
    @Path(value="events/{eventId}")
    @Operation(summary="Store event announcement", description="Stores the given event announcement.", tags={"Event Announcement"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void storeEventAnnouncement(@PathParam(value="eventId") String eventId, EventAnnouncement event) throws BadRequestException, ConQATException {
        Preconditions.checkArgument((boolean)eventId.equals(event.eventId()), (Object)"Event IDs do not match");
        if (!event.learnMoreUrl().contains("://")) {
            event = new EventAnnouncement(event.eventId(), event.startIsoLocalDateTime(), event.endIsoLocalDateTime(), event.timezone(), event.headline(), event.description(), "http://" + event.learnMoreUrl());
        }
        EventAnnouncementIndex eventPromotionIndex = this.getEventAnnouncementIndex();
        eventPromotionIndex.wipeIndex();
        eventPromotionIndex.storeEventAnnouncement(event);
    }

    @DELETE
    @Path(value="delete/{eventId}")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Delete event announcement", description="Deletes the given announcement so it will not be displayed to anyone anymore.", tags={"Event Announcement"})
    public void deleteEventAnnouncement(@PathParam(value="eventId") String eventId) throws StorageException {
        EventAnnouncementIndex eventAnnouncementIndex = this.getEventAnnouncementIndex();
        eventAnnouncementIndex.removeEvent(eventId);
    }

    @POST
    @Path(value="hide")
    @Operation(summary="Hide event announcement", description="Hides the event announcement with the given ID for the logged-in user. The event will no longer be advertised to the user.", tags={"Event Announcement"})
    @RequiresNoPermission
    public void hideEventAnnouncement(String eventId) throws BadRequestException, ConQATException {
        this.openGlobalIndex(UserEventAnnouncementPreferencesIndex.class).hideEventForUser(this.getUser().getUsername(), eventId);
    }

    private EventAnnouncementIndex getEventAnnouncementIndex() throws StorageException {
        return this.openGlobalIndex(EventAnnouncementIndex.class);
    }
}

