/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisSessionInfo;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.util.CsvServiceUtils;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.supercsv.io.CsvListWriter;

@Path(value="api/projects/{project}/external-analysis/debug/")
public class DebugListOpenSessionsService
extends ApiBase {
    @GET
    @Path(value="open-sessions.csv")
    @Operation(summary="Returns a list with information about all open sessions.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/csv"})
    public String getAllOpenSessions() throws StorageException {
        return CsvServiceUtils.createCsvString(this::createCsvFromSessions);
    }

    @GET
    @Path(value="open-sessions")
    @Operation(summary="Returns a list with all IDs of open sessions.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public List<String> getAllOpenSessionInfos() throws StorageException {
        return this.openSessionIndex().getAllSessionInfos().stream().map(ImmutablePair::getSecond).filter(ExternalAnalysisSessionInfo::isOpen).map(ExternalAnalysisSessionInfo::getSessionId).toList();
    }

    private void createCsvFromSessions(CsvListWriter writer) throws StorageException, IOException {
        ExternalAnalysisImportSessionIndex sessionIndex = this.openSessionIndex();
        Collection sessionIds = sessionIndex.getAllSessionIds();
        writer.writeHeader(new String[]{"Session ID", "Creator", "Upload Time", "Partition", "Max report size", "Commit", "Message"});
        for (String sessionId : sessionIds) {
            sessionIndex.getSessionInfo(sessionId).ifPresent(sessionInfo -> DebugListOpenSessionsService.writeSessionInfoInCsv(sessionInfo, writer, sessionId));
        }
    }

    private ExternalAnalysisImportSessionIndex openSessionIndex() throws StorageException {
        return this.openProjectIndex(ExternalAnalysisImportSessionIndex.class, null);
    }

    private static void writeSessionInfoInCsv(ExternalAnalysisSessionInfo sessionInfo, CsvListWriter writer, String sessionId) {
        if (sessionInfo.isOpen()) {
            try {
                writer.write(new Object[]{sessionId, sessionInfo.getUsername(), new Date(sessionInfo.getUploadTimestamp()), sessionInfo.getPartition(), sessionInfo.getMaxReportSize(), sessionInfo.getCommit(), sessionInfo.getMessage()});
            }
            catch (IOException e) {
                LogManager.getLogger().warn(e.getMessage());
            }
        }
    }
}

