/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.input;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.rest.EHttpMethod;
import com.teamscale.core.rest.IExternalUploadRequestPart;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisImportSessionManager;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisSessionInfo;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndex;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceBase;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceQueryOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/external-analysis/session")
public class ExternalAnalysisSessionService
extends SessionBasedExternalAnalysisServiceBase<SessionBasedExternalAnalysisServiceQueryOptions> {
    private static final Logger LOGGER = LogManager.getLogger();

    @POST
    @PublicApi(since=ETeamscaleVersion.VERSION_5_9_0)
    @Operation(summary="Get session ID", description="Obtains a new session ID. Using session ID allows to perform external uploads in multiple calls that all belong to the same session.", tags={"External Analysis"}, responses={@ApiResponse(responseCode="400", description="Partition name not provided."), @ApiResponse(responseCode="404", description="Revision provided in the query parameter could not be found."), @ApiResponse(responseCode="400", description="Upload was rejected, because it refers to a timestamp too far back in time.")})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    public String createSession(@BeanParam SessionBasedExternalAnalysisServiceQueryOptions parameters) throws StorageException {
        LOGGER.traceEntry("createSession(parameters={})", new Object[]{parameters});
        this.requirePartition(parameters);
        this.logManager.logParameters(EHttpMethod.POST, parameters);
        LOGGER.trace("Opening external analysis status index ...");
        ExternalAnalysisStatusIndex statusIndex = this.openProjectIndex(ExternalAnalysisStatusIndex.class, null);
        LOGGER.trace("Creating new session ...");
        ExternalAnalysisSessionInfo session = this.createNewSession(this.createSessionManager(), parameters);
        LOGGER.trace("Logging success and storing external upload status ...");
        this.logManager.logSuccess();
        this.storeStatus(statusIndex, session, true);
        return (String)LOGGER.traceExit((Object)session.getSessionId());
    }

    @POST
    @Path(value="{sessionId}")
    @PublicApi(since=ETeamscaleVersion.VERSION_5_9_0)
    @Operation(summary="Commit session", description="Commits and closes the given session.", tags={"External Analysis"}, responses={@ApiResponse(responseCode="404", description="No session with provided id found.")})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    public void commitAnalysisResults(@Parameter(description="If session ID is provided, the results will be appended to the given session instead of creating a new session. Use \"auto-create\" in place of session ID to create a new session, perform upload and commit session in one step.") @PathParam(value="sessionId") String sessionId) throws StorageException {
        this.logManager.logHttpMethod(EHttpMethod.POST);
        ExternalAnalysisStatusIndex statusIndex = this.openProjectIndex(ExternalAnalysisStatusIndex.class, null);
        ExternalAnalysisImportSessionManager sessionManager = this.createSessionManager();
        ExternalAnalysisSessionInfo session = this.commitSession(sessionId, sessionManager);
        this.logManager.logSuccess();
        this.storeStatus(statusIndex, session, true);
    }

    @DELETE
    @Path(value="{sessionId}")
    @PublicApi(since=ETeamscaleVersion.VERSION_5_9_0)
    @Operation(summary="Delete session", description="Deletes a session in case of abortion.", tags={"External Analysis"}, responses={@ApiResponse(responseCode="404", description="No session with provided id found.")})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    public void deleteAnalysisResults(@Parameter(description="If session ID is provided, the results will be appended to the given session instead of creating a new session. Use \"auto-create\" in place of session ID to create a new session, perform upload and commit session in one step.") @PathParam(value="sessionId") String sessionId) throws StorageException {
        this.logManager.logHttpMethod(EHttpMethod.DELETE);
        ExternalAnalysisStatusIndex statusIndex = this.openProjectIndex(ExternalAnalysisStatusIndex.class, null);
        ExternalAnalysisSessionInfo session = ExternalAnalysisSessionService.deleteSession(sessionId, this.createSessionManager());
        this.logManager.logSuccess();
        this.storeStatus(statusIndex, session, true);
    }

    @Override
    protected void processRequest(ExternalAnalysisSessionInfo session, ExternalAnalysisImportSessionManager sessionManager, List<IExternalUploadRequestPart> externalAnalysisResults, SessionBasedExternalAnalysisServiceQueryOptions parameters) {
    }
}

