/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.google.common.collect.ImmutableList;
import com.teamscale.index.findings.calculation.ExcludedFindingsCount;
import com.teamscale.index.findings.calculation.ExtendedFindingsWithCount;
import com.teamscale.index.findings.calculation.FindingsFilterSettings;
import com.teamscale.index.findings.calculation.FindingsPaginationOptions;
import com.teamscale.index.resource.ContainerIndex;
import com.teamscale.index.resource.ContainerInfo;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.index.resource.path_lookup.PathLookupOptions;
import com.teamscale.index.testgap.abap.AbapIncludeIndex;
import com.teamscale.service.findings.ElementFindingsServiceBase;
import com.teamscale.service.findings.FindingsSortUtils;
import com.teamscale.service.findings.IAbapElementFindingsServiceApi;
import com.teamscale.service.findings.options.FindingSortOptions;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.abap.ParsedAbapElementPath;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@Path(value="api/projects/{project}/findings/abap")
public class AbapElementFindingsService
extends ElementFindingsServiceBase
implements IAbapElementFindingsServiceApi {
    private static final FindingSortOptions DEFAULT_SORTING_OPTIONS = new FindingSortOptions();
    private static final FindingsPaginationOptions NO_PAGINATION_OPTIONS = FindingsPaginationOptions.all();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern NAMESPACED_OBJECT_PATTERN = Pattern.compile("(![^!]+!)?(.*)");

    @Override
    public ExtendedFindingsWithCount getAbapFindings(FindingsFilterSettings findingsFilterSettings, FindingSortOptions sortOptions, FindingsPaginationOptions paginationOptions) throws StorageException {
        return super.retrieveFilteredFindingsWithSortingAndPagination(UniformPath.codeRoot(), false, findingsFilterSettings, sortOptions, paginationOptions);
    }

    @Override
    public ExtendedFindingsWithCount getAbapFindings(EAbapObjectType objectType, String objectName, FindingsFilterSettings findingsFilterSettings, boolean reportMissingObjects) throws StorageException {
        HistoryAccessOption historyAccessOption;
        ImmutableList<String> paths;
        Optional<UniformPath> uniformPath;
        if (objectType == EAbapObjectType.FUGR) {
            Matcher matcher = NAMESPACED_OBJECT_PATTERN.matcher((CharSequence)objectName);
            CCSMAssert.isTrue((boolean)matcher.find(), (String)("The namespace pattern did not apply to the name " + (String)objectName));
            objectName = StringUtils.emptyIfNull((String)matcher.group(1)) + "SAPL" + matcher.group(2);
        }
        if ((uniformPath = (paths = this.lookupAbapObject(historyAccessOption = this.determineHistoryOption(findingsFilterSettings.getCommit()), objectType, (String)objectName)).stream().filter(path -> AbapElementFindingsService.isOfType(path, objectType)).findAny().map(UniformPathCompatibilityUtil::convert)).isEmpty()) {
            if (reportMissingObjects) {
                throw new NotFoundException("Source object not found.");
            }
            return new ExtendedFindingsWithCount(Collections.emptyList(), new ExcludedFindingsCount(0, 0, 0, 0, 0));
        }
        ExtendedFindingsWithCount findings = this.getFindingsConsiderTransitiveIncludes(findingsFilterSettings, historyAccessOption, uniformPath.get());
        if (objectType == EAbapObjectType.CLAS) {
            for (UniformPath childPath : this.determineChildrenPaths(uniformPath.get(), historyAccessOption)) {
                ExtendedFindingsWithCount findingsInChild = this.getFindingsConsiderTransitiveIncludes(findingsFilterSettings, historyAccessOption, childPath);
                findings = ExtendedFindingsWithCount.merge((ExtendedFindingsWithCount)findings, (ExtendedFindingsWithCount)findingsInChild);
            }
        }
        FindingsSortUtils.sortFindings(findings.findings(), DEFAULT_SORTING_OPTIONS);
        return findings;
    }

    private List<UniformPath> determineChildrenPaths(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        ArrayList<String> segments = new ArrayList<String>((Collection<String>)uniformPath.getPathSegments());
        segments.set(segments.size() - 1, StringUtils.stripSuffix((String)((String)segments.getLast()), (String)".abap"));
        UniformPath folderPath = UniformPath.ofSegments(segments);
        ContainerIndex containerIndex = this.openProjectIndex(ContainerIndex.class, "dir", historyAccessOption);
        ContainerInfo folder = containerIndex.getContainer(folderPath.toString());
        if (folder == null) {
            return List.of();
        }
        return CollectionUtils.map((Collection)folder.getChildren(), UniformPathCompatibilityUtil::convert);
    }

    private ExtendedFindingsWithCount getFindingsConsiderTransitiveIncludes(FindingsFilterSettings findingsFilterSettings, HistoryAccessOption historyAccessOption, UniformPath uniformPath) throws StorageException {
        AbapIncludeIndex includeIndex = this.openProjectIndex(AbapIncludeIndex.class, historyAccessOption);
        ExtendedFindingsWithCount resultFindingsWithCount = super.retrieveFilteredFindingsWithSortingAndPagination(uniformPath, false, findingsFilterSettings, DEFAULT_SORTING_OPTIONS, NO_PAGINATION_OPTIONS);
        SetMap outboundsTransitive = includeIndex.getOutboundsTransitive(Collections.singletonList(uniformPath.toString()));
        for (String path : (Set)outboundsTransitive.getValues()) {
            UniformPath includePath = UniformPath.ofSegments((String[])path.split(UniformPathUtils.SEPARATOR));
            ExtendedFindingsWithCount findingsWithCount = super.retrieveFilteredFindingsWithSortingAndPagination(includePath, false, findingsFilterSettings, DEFAULT_SORTING_OPTIONS, NO_PAGINATION_OPTIONS);
            resultFindingsWithCount = ExtendedFindingsWithCount.merge((ExtendedFindingsWithCount)resultFindingsWithCount, (ExtendedFindingsWithCount)findingsWithCount);
        }
        return resultFindingsWithCount;
    }

    private ImmutableList<String> lookupAbapObject(HistoryAccessOption historyAccessOption, EAbapObjectType objectType, String objectName) throws StorageException {
        String fileExtension = ".abap";
        if (EAbapObjectType.DDIC_OBJECT_TYPES.contains(objectType)) {
            fileExtension = ".abap_ddic";
        } else if (EAbapObjectType.CDS_OBJECT_TYPES.contains(objectType)) {
            fileExtension = ".abap_cds";
        }
        PathLookupIndex lookupIndex = this.openProjectIndex(PathLookupIndex.class, historyAccessOption);
        Optional result = lookupIndex.lookupPath(objectName + fileExtension, PathLookupOptions.defaults());
        if (result.isPresent()) {
            return (ImmutableList)((Pair)result.get()).getSecond();
        }
        return lookupIndex.lookupSuffix(objectName + ")" + fileExtension);
    }

    private static boolean isOfType(String uniformPath, EAbapObjectType objType) {
        ParsedAbapElementPath parsedPath;
        try {
            parsedPath = new ParsedAbapElementPath(uniformPath, false);
        }
        catch (ConQATException e) {
            LOGGER.error(e.getMessage());
            return false;
        }
        return parsedPath.getElementName().getObjectType() == objType;
    }
}

