/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.cppcheck;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.findings.CppIncludeHandler;
import com.teamscale.index.findings.CppToolAnalysisTokenElementDetails;
import com.teamscale.index.findings.cppcheck.CppcheckRunner;
import com.teamscale.index.findings.cppcheck.CppcheckSynchronizer;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.CompileCommandIndex;
import com.teamscale.index.resource.FileIncludeLookup;
import com.teamscale.index.resource.SystemIncludeFileCacheIndex;
import com.teamscale.index.resource.SystemIncludeFileLookup;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.findings.SetupVerificationServiceUtils;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.distribution.LocalLockProvider;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.jspecify.annotations.NonNull;

@Path(value="api/verify")
public class VerifyCppcheckSetupService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String EXAMPLE_FILE_CONTENT = "int* test() {\n \tint c[5];\n    for (int i = 0; i < 5; i++) c[i] = a[i]+b[i];\n    int* out = c;\n    return out;\n }\n";
    private static final List<String> SELECTED_CHECKS_CPPCHECK = List.of("returnDanglingLifetime", "misra-c2012-15.6");
    private static final List<String> SELECTED_CHECKS_CPPCHECK_PREMIUM = List.of("premium-returnDanglingLifetime", "premium-misra-c-2023-15.6", "premium-misra-c-2023-dir-4.6");
    private static final String EXPECTED_FINDINGS_CPPCHECK = "\tReturning pointer to local variable 'c' that will be invalid when returning. at src/test.c:5-5\n\tThe body of an iteration-statement or a selection-statement shall be a compound-statement at src/test.c:3-3\n";
    private static final String EXPECTED_FINDINGS_CPPCHECK_PREMIUM = "\ttypedefs that indicate size and signedness should be used in place of the basic numerical types at src/test.c:1-1\n\ttypedefs that indicate size and signedness should be used in place of the basic numerical types at src/test.c:2-2\n\tThe body of an iteration-statement or a selection-statement shall be a compound-statement at src/test.c:3-3\n\ttypedefs that indicate size and signedness should be used in place of the basic numerical types at src/test.c:3-3\n\ttypedefs that indicate size and signedness should be used in place of the basic numerical types at src/test.c:4-4\n\tReturning pointer to local variable 'c' that will be invalid when returning. at src/test.c:5-5\n";

    @GET
    @Path(value="cppcheck-setup")
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_ANALYSIS_PROFILES})
    @Operation(summary="Verifies that there is a cppcheck installed on the server, has the required\n version, and can be called by Teamscale.", description="Verifies the cppcheck installation on the server.", tags={"Source Code"})
    public String verifyCppcheckInternalSetup() {
        return this.verifyCppcheckSetup(false);
    }

    @GET
    @Path(value="cppcheck-premium-setup")
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_ANALYSIS_PROFILES})
    @Operation(summary="Verifies that there is a cppcheck premium installed on the server, has the required\n version, and can be called by Teamscale.", description="Verifies the cppcheck premium installation on the server.", tags={"Source Code"})
    public String verifyCppcheckPremiumSetup() {
        return this.verifyCppcheckSetup(true);
    }

    private String verifyCppcheckSetup(boolean cppcheckPremiumEnabled) {
        StringBuilder resultMessage = new StringBuilder("This service verifies that there is a cppcheck" + (cppcheckPremiumEnabled ? "-premium" : "") + " installed on the Teamscale host. It checks whether the cppcheck executable can be called, has the required version, and tries to analyze a small example program.\n\n");
        try {
            SetupVerificationServiceUtils.printVersionInformation(resultMessage, "cppcheck", CppcheckRunner.loadConfiguredCppcheckExe(), CppcheckSynchronizer.loadExpectedCppcheckVersion((boolean)cppcheckPremiumEnabled), "com.teamscale.cppcheck-exe");
            CppcheckSynchronizer.verifyCppcheckVersion((boolean)cppcheckPremiumEnabled);
            resultMessage.append("OK\n");
            resultMessage.append("\n\nSetting up test example in temporary directory.\n");
            VerifyCppcheckSetupService.analyzeExampleCode(resultMessage, cppcheckPremiumEnabled);
        }
        catch (Throwable t) {
            resultMessage.append("Caught an exception (more details in the service log):").append("\n");
            resultMessage.append(t.getMessage()).append("\n");
            LOGGER.error((Object)t);
        }
        return resultMessage.toString();
    }

    private static @NonNull CppIncludeHandler buildIncludeHandler(TokenElementInfo mainFile) throws StorageException {
        TokenElementIndex contentIndex = new TokenElementIndex((IStore)new InMemoryStore());
        BasicTokenElementIndex basicContentIndex = new BasicTokenElementIndex((IStore)new InMemoryStore());
        CompileCommandIndex compileCommandIndex = new CompileCommandIndex((IStore)new InMemoryStore());
        PathLookupIndex pathLookupIndex = new PathLookupIndex((IStore)new InMemoryStore());
        contentIndex.setTokenElement(mainFile.getUniformPath(), mainFile);
        basicContentIndex.setTokenElement((BasicTokenElementInfo)mainFile);
        SystemIncludeFileLookup systemIncludeFileLookup = new SystemIncludeFileLookup(new SystemIncludeFileCacheIndex((IStore)new InMemoryStore()), Collections.emptyList());
        FileIncludeLookup fileIncludeLookup = new FileIncludeLookup((IMatchingPathsLookup)pathLookupIndex, systemIncludeFileLookup);
        return new CppIncludeHandler(basicContentIndex, compileCommandIndex, fileIncludeLookup, (ILockProvider)new LocalLockProvider());
    }

    private static void analyzeExampleCode(StringBuilder resultMessage, boolean cppcheckPremiumEnabled) throws StorageException, IOException {
        String expectedFindings = cppcheckPremiumEnabled ? EXPECTED_FINDINGS_CPPCHECK_PREMIUM : EXPECTED_FINDINGS_CPPCHECK;
        List<String> selectedChecks = cppcheckPremiumEnabled ? SELECTED_CHECKS_CPPCHECK_PREMIUM : SELECTED_CHECKS_CPPCHECK;
        CodeScopeAware defaultEnabledChecks = CodeScopeAware.defaultCodeScopeWithValue((Object)(cppcheckPremiumEnabled ? ".*" : ".*"));
        TokenElementInfo mainFile = TokenElementInfo.createWithLocalPreprocessing((String)"src/test.c", (ELanguage)ELanguage.C, (String)EXAMPLE_FILE_CONTENT);
        File tempDir = new File(FileSystemUtils.getTmpDir(), "cppcheck_setup_verifier_" + System.currentTimeMillis());
        resultMessage.append("Using temp dir ").append(tempDir.getAbsolutePath()).append("\n");
        SetupVerificationServiceUtils.setupCleanTargetDir(tempDir.getAbsolutePath());
        resultMessage.append("Using example file\n").append(EXAMPLE_FILE_CONTENT).append("\n");
        resultMessage.append("Using checks").append("\n");
        for (String check : selectedChecks) {
            resultMessage.append("\t").append(check).append("\n");
        }
        resultMessage.append("Generating execution environment and running cppcheck.").append("\n");
        CodeScopeAware globalCompilerArguments = CodeScopeAware.from((CodeScopeName)CodeScopeDetail.getCodeScopeNameFromTokenElement((BasicTokenElementInfo)mainFile), Collections.emptyList());
        CppToolAnalysisTokenElementDetails tokenElementDetails = CppToolAnalysisTokenElementDetails.extractFromTokenElement((TokenElementInfo)mainFile);
        ListMap analysisResults = CppcheckRunner.prepareAndRunCppcheck(Collections.singletonList(mainFile), (File)tempDir, (CodeScopeAware)CppcheckSynchronizer.loadCheckMappingsForEnabledChecks((CodeScopeAware)CodeScopeAware.defaultCodeScopeWithValue(selectedChecks), Collections.singleton(CodeScopeAware.DEFAULT_CODE_SCOPE), (boolean)cppcheckPremiumEnabled), (CodeScopeAware)defaultEnabledChecks, (CodeScopeAware)globalCompilerArguments, (boolean)false, (CppIncludeHandler)VerifyCppcheckSetupService.buildIncludeHandler(mainFile), (boolean)cppcheckPremiumEnabled, (CppToolAnalysisTokenElementDetails)tokenElementDetails);
        if (analysisResults.getKeys().contains((Object)mainFile.getUniformPath())) {
            List<IndexFinding> findings = Objects.requireNonNull((List)analysisResults.getCollection((Object)mainFile.getUniformPath())).stream().toList();
            resultMessage.append("generatedFindings:").append("\n");
            String actualFindings = SetupVerificationServiceUtils.formatFindingsString(findings);
            resultMessage.append(actualFindings);
            if (SetupVerificationServiceUtils.linesAreEqualAnyOrder(actualFindings, expectedFindings)) {
                resultMessage.append("These are exactly the expected findings. Everything is ok.\n");
            } else {
                resultMessage.append("These are not exactly the expected findings. Something is wrong.\n");
                resultMessage.append("The expected findings are:\n").append(expectedFindings);
            }
        } else {
            resultMessage.append("Cppcheck did not generate findings (something is wrong).\n");
        }
    }
}

