/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.refactoring;

import com.teamscale.service.findings.refactoring.ExtractMethodCandidate;
import com.teamscale.service.findings.refactoring.Method;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.util.Collection;
import java.util.List;

public class ScoreCalculator {
    public static double getTotalScore(ExtractMethodCandidate candidate, Method method) {
        double lengthReductionScore = ScoreCalculator.calculateBoundedScore(0.1, ScoreCalculator.getLengthReduction(candidate, method), 0.0, 3.0);
        double nestingScore = ScoreCalculator.calculateUnboundedScore(0.135, ScoreCalculator.getNestingAreaReduction(candidate, method));
        double transformedNumberOfInputParameter = ScoreCalculator.getTransformedNumberOfInputParameter(candidate, method);
        double inputParameterScore = ScoreCalculator.calculateUnboundedScore(-0.5, transformedNumberOfInputParameter);
        double existenceOfCommentsOrBlankLinesAtBeginningScore = ScoreCalculator.calculateUnboundedScore(0.25, ScoreCalculator.getExistenceOfIntroducingCommentsOrBlankLines(candidate));
        double numberOfCommentsOrBlankLinesAtBeginningScore = ScoreCalculator.calculateBoundedScore(0.25, ScoreCalculator.getNumberOfIntroducingCommentsOrBlankLines(candidate), 0.0, 1.0);
        double existenceOfCommentsOrBlankLinesAtEndScore = ScoreCalculator.calculateUnboundedScore(0.25, ScoreCalculator.getExistenceOfTrailingCommentsOrBlankLines(candidate));
        double numberOfCommentsOrBlankLinesAtEndScore = ScoreCalculator.calculateBoundedScore(0.079, ScoreCalculator.getNumberOfTrailingCommentsOrBlankLines(candidate), 0.0, 0.487);
        return lengthReductionScore + inputParameterScore + nestingScore + existenceOfCommentsOrBlankLinesAtBeginningScore + numberOfCommentsOrBlankLinesAtBeginningScore + existenceOfCommentsOrBlankLinesAtEndScore + numberOfCommentsOrBlankLinesAtEndScore;
    }

    private static double calculateBoundedScore(double weight, double value, double lowerScoreBound, double upperScoreBound) {
        return Math.min(Math.max(weight * value, lowerScoreBound), upperScoreBound);
    }

    private static double calculateUnboundedScore(double weight, double value) {
        return weight * value;
    }

    private static double getLengthReduction(ExtractMethodCandidate candidate, Method method) {
        int sLocMethod = ShallowEntityTraversalUtils.getAllEntities((Collection)method.getEntity().getChildren()).size();
        int sLocCandidate = ShallowEntityTraversalUtils.getAllEntities(candidate.getShallowEntities()).size();
        return Math.min(sLocMethod - sLocCandidate, sLocCandidate - 1);
    }

    public static int getNestingAreaReduction(ExtractMethodCandidate candidate, Method method) {
        int candidateNestingArea = ShallowParsingUtils.getNestingArea(candidate.getShallowEntities());
        return Math.min(candidateNestingArea, method.getNestingArea() - candidateNestingArea);
    }

    private static double getTransformedNumberOfInputParameter(ExtractMethodCandidate candidate, Method method) {
        int maximalNumberOfAllowedInputParameters;
        int numberOfInputParameters = candidate.getInputParameters().size();
        if (numberOfInputParameters > (maximalNumberOfAllowedInputParameters = ScoreCalculator.getMaximalNumberOfAllowedParameter(method))) {
            return 20000.0;
        }
        return numberOfInputParameters + -1 * maximalNumberOfAllowedInputParameters;
    }

    private static int getMaximalNumberOfAllowedParameter(Method method) {
        int numberOfOriginalMethodInputParameters = method.getNumberOfInputParameters();
        return Math.max(3, numberOfOriginalMethodInputParameters);
    }

    private static int getExistenceOfIntroducingCommentsOrBlankLines(ExtractMethodCandidate candidate) {
        int numberOfIntroducingCommentsOrBlankLines = ShallowParsingUtils.getNumberOfBlankLinesOrCommentsBefore((ShallowEntity)candidate.getShallowEntities().get(0));
        if (numberOfIntroducingCommentsOrBlankLines > 0) {
            return 1;
        }
        return 0;
    }

    private static int getNumberOfIntroducingCommentsOrBlankLines(ExtractMethodCandidate candidate) {
        return ShallowParsingUtils.getNumberOfBlankLinesOrCommentsBefore((ShallowEntity)candidate.getShallowEntities().get(0));
    }

    private static int getExistenceOfTrailingCommentsOrBlankLines(ExtractMethodCandidate candidate) {
        List<ShallowEntity> shallowEntities = candidate.getShallowEntities();
        int numberOfTrailingCommentsOrBlankLines = ShallowParsingUtils.getNumberOfBlankLinesOrCommentsAfter((ShallowEntity)shallowEntities.get(shallowEntities.size() - 1));
        if (numberOfTrailingCommentsOrBlankLines > 0) {
            return 1;
        }
        return 0;
    }

    private static int getNumberOfTrailingCommentsOrBlankLines(ExtractMethodCandidate candidate) {
        List<ShallowEntity> shallowEntities = candidate.getShallowEntities();
        return ShallowParsingUtils.getNumberOfBlankLinesOrCommentsAfter((ShallowEntity)shallowEntities.get(shallowEntities.size() - 1));
    }
}

