/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.sonarlint;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.findings.sonarlint.independent_analysis.ESonarLintIndependentAnalysisStatus;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintFileInfo;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintFindingTransport;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisContext;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisContextIndex;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisFindingsCache;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisRequestParameters;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisRunner;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisStatusIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import net.jpountz.xxhash.StreamingXXHash64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.jspecify.annotations.Nullable;

@Path(value="api/analysis/sonarlint")
public class SonarLintAnalysisService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_PROJECTS})
    @Operation(summary="Request a SonarLint analysis", description="Opens and schedules a new SonarLint analysis session, returning the session key.", tags={"External Analysis"})
    public String requestAnalysisAndOpenSession(@QueryParam(value="projectId") @Nullable IProjectId projectId, @QueryParam(value="commitDescriptor") @Nullable UnresolvedCommitDescriptor commit, @QueryParam(value="returnAddress") @Nullable String returnAddress, @RequestBody(required=true) SonarLintIndependentAnalysisRequestParameters parameters) throws StorageException, IOException, ServiceCallException {
        LOGGER.debug("Received request for SonarLint analysis on {} file(s).", new Supplier[]{() -> parameters.fileInfos().size()});
        if (projectId == null || commit == null || returnAddress == null) {
            throw new ServiceCallException(String.format("If one of project ID, commit or return address is provided, all of them are required. Provided project ID '%s', commit '%s' and return address '%s'.", projectId, commit, returnAddress));
        }
        String sessionKey = this.generateSessionKey(projectId, commit, parameters);
        this.scheduleAnalysisTrigger(projectId, commit, returnAddress, parameters, sessionKey);
        return sessionKey;
    }

    @GET
    @Path(value="status")
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_PROJECTS})
    @Operation(summary="Get the status of a SonarLint Analysis session", description="Gets the status of the given session. May return the 'unknown' status, if no session was found for the given key.", tags={"External Analysis"})
    public ESonarLintIndependentAnalysisStatus getAnalysisStatus(@QueryParam(value="sessionKey") String sessionKey) throws StorageException {
        ESonarLintIndependentAnalysisStatus status = ((SonarLintIndependentAnalysisStatusIndex)this.getIndexLayer().openGlobalIndex(SonarLintIndependentAnalysisStatusIndex.class)).getStatus(sessionKey);
        LOGGER.debug("Received request to read status of session '{}'; current status is {}.", (Object)sessionKey, (Object)status.name());
        return status;
    }

    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_PROJECTS})
    @Operation(summary="Get SonarLint analysis results", description="Gets the SonarLint analysis results. Results may be incomplete if the session is not in the completed status.", tags={"External Analysis"}, responses={@ApiResponse(responseCode="404", description="No session found with the given key.")})
    public ListMap<String, SonarLintFindingTransport> getAnalysisResultsByPath(@QueryParam(value="sessionKey") String sessionKey) throws StorageException {
        LOGGER.debug("Received request to read SonarLint findings for session '{}'.", (Object)sessionKey);
        IndexLayer indexLayer = this.getIndexLayer();
        SonarLintIndependentAnalysisContext context = (SonarLintIndependentAnalysisContext)((SonarLintIndependentAnalysisContextIndex)indexLayer.openGlobalIndex(SonarLintIndependentAnalysisContextIndex.class)).getContext(sessionKey).orElseThrow(() -> new NotFoundException("No session found with key '" + sessionKey + "'."));
        ListMap cacheContent = ((SonarLintIndependentAnalysisFindingsCache)indexLayer.openGlobalIndex(SonarLintIndependentAnalysisFindingsCache.class)).readCache(CollectionUtils.map((Collection)context.fileInfos(), SonarLintFileInfo::hash));
        ListMap transportContent = new ListMap();
        for (Map.Entry cacheEntry : cacheContent.entrySet()) {
            transportContent.addAll((Object)((String)cacheEntry.getKey()), (Collection)CollectionUtils.map((Collection)((Collection)cacheEntry.getValue()), SonarLintFindingTransport::fromFinding));
        }
        return transportContent;
    }

    private String generateSessionKey(@Nullable IProjectId projectId, @Nullable UnresolvedCommitDescriptor commit, SonarLintIndependentAnalysisRequestParameters parameters) {
        StreamingXXHash64 hash = XXHashUtils.streamingHash64();
        if (projectId != null && commit != null) {
            XXHashUtils.updateHash((StreamingXXHash64)hash, (String)projectId.toString());
            XXHashUtils.updateHash((StreamingXXHash64)hash, (String)commit.getBranchName());
            XXHashUtils.updateHash((StreamingXXHash64)hash, (byte[])ByteArrayUtils.longToByteArray((long)commit.getTimestamp()));
        } else {
            XXHashUtils.updateHash((StreamingXXHash64)hash, (String)UUID.randomUUID().toString());
        }
        XXHashUtils.updateHash((StreamingXXHash64)hash, (String)String.valueOf(parameters.hashCode()));
        return String.valueOf(hash.getValue());
    }

    private void scheduleAnalysisTrigger(@Nullable IProjectId projectId, @Nullable UnresolvedCommitDescriptor commit, @Nullable String returnAddress, SonarLintIndependentAnalysisRequestParameters parameters, String sessionKey) throws StorageException {
        SonarLintIndependentAnalysisStatusIndex statusIndex = this.openGlobalIndex(SonarLintIndependentAnalysisStatusIndex.class);
        if (statusIndex.getStatus(sessionKey) != ESonarLintIndependentAnalysisStatus.UNKNOWN) {
            return;
        }
        try {
            statusIndex.setStatus(sessionKey, ESonarLintIndependentAnalysisStatus.SCHEDULED);
            SonarLintIndependentAnalysisContext context = new SonarLintIndependentAnalysisContext(returnAddress, projectId, commit, parameters.selectedChecks(), parameters.selectedOptions(), parameters.checkOptionValues(), parameters.javaSourceLevel(), parameters.fileInfos());
            this.openGlobalIndex(SonarLintIndependentAnalysisContextIndex.class).storeContext(sessionKey, context);
            ISchedulerCommunicator.getInstance().scheduleMaintenanceTrigger(SonarLintIndependentAnalysisRunner.class, sessionKey, "Scheduled due to external SonarLint analysis request.", this.getIndexLayer());
        }
        catch (Throwable t) {
            statusIndex.setStatus(sessionKey, ESonarLintIndependentAnalysisStatus.UNKNOWN);
            throw t;
        }
    }
}

