/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.issues.jira.voting.JiraIssueUpdatePostAnalysisTrigger;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/projects/{project}/issues/debug/issue-badge-update")
public class DebugForceIssueBadgeUpdateService
extends ApiBase {
    @POST
    @Operation(summary="Update issue badge", description="This service allows force pushing of the latest information available for issues into Jira. If an 'issue-id' is provided, then the specified issue will be updated. Otherwise, all issues in the project will be updated.This should only be used for debugging.", tags={"Issues", "Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public String forceJiraIssueUpdate(@QueryParam(value="issue-id") @Parameter(description="The format is the connector ID of the originating issue tracker/requirements management tool (as specified in the connector settings in the project configuration), followed by the separator '|', followed by the ID of the issue, as it is provided by the external issue tracker/requirements management tool. For example, an issue with the ID \"TS-123\" is imported using an issue tracker connector with the connector ID \"issues1\". The expected ID is then \"issues1|TS-123\". Leave empty to update all issues in the project.", schema=@Schema(type="string")) TeamscaleIssueId issueId) throws StorageException {
        IssueIndex issueIndex = this.openProjectIndex(IssueIndex.class, null);
        if (issueId == null) {
            return this.updateIssues(issueIndex.getAllIssues(), "No relevant issues were found in the project to update.");
        }
        TeamscaleIssue issue = issueIndex.getIssue(issueId);
        if (issue == null) {
            throw new NotFoundException("The issue with ID '" + String.valueOf(issueId) + "' could not be found!");
        }
        return this.updateIssues(Collections.singletonList(issue), "Did not schedule update for issue '" + String.valueOf(issueId) + "', because it does not have any commits mapped to it.");
    }

    private String updateIssues(List<TeamscaleIssue> allIssues, String notScheduledMessage) throws StorageException {
        RepositoryCommitIssueMappingIndex issueCommitMappingIndex = this.openProjectIndex(RepositoryCommitIssueMappingIndex.class, null);
        ArrayList<TeamscaleIssueId> issueIdsToUpdate = new ArrayList<TeamscaleIssueId>();
        for (TeamscaleIssue issue : allIssues) {
            TeamscaleIssueId issueId = issue.getId();
            Optional firstAndLastCommitForIssue = issueCommitMappingIndex.getFirstAndLastCommitForIssue(issueId);
            if (!firstAndLastCommitForIssue.isPresent()) continue;
            issueIdsToUpdate.add(issueId);
        }
        if (issueIdsToUpdate.isEmpty()) {
            return notScheduledMessage;
        }
        String issueIds = StringUtils.concat(issueIdsToUpdate, (String)",");
        JobDescriptor jiraIssueUpdateJob = new JobDescriptor(this.serviceInfo.getInternalId(), JiraIssueUpdatePostAnalysisTrigger.class, null, (Object)issueIds, "Forced update of issue(s): " + issueIds + " by user " + this.getUser().getUsername());
        ISchedulerCommunicator.getInstance().scheduleExternalJob(this.serviceInfo.getIndexLayer(), jiraIssueUpdateJob);
        return "Forced update of issue(s): " + issueIds + " scheduled.";
    }
}

