/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.logs;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.js.DetailedJavaScriptErrorLog;
import com.teamscale.core.log.js.ShortJavaScriptErrorLog;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.logging.LogFilteringParameters;
import com.teamscale.service.framework.logging.LogIndexesWrapper;
import com.teamscale.service.framework.logging.LogServiceUtils;
import com.teamscale.service.framework.logging.ProjectLogLevelFrequencies;
import com.teamscale.service.framework.logging.ShortLogResponse;
import com.teamscale.service.logs.IProjectLogServiceApi;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/projects/{project}/logs/javascript-errors")
public class JavascriptErrorsProjectLogService
extends ApiBase
implements IProjectLogServiceApi<ShortJavaScriptErrorLog, DetailedJavaScriptErrorLog> {
    @Override
    @Operation(summary="Get all JS error logs", description="Returns a list of all JavaScript error short logs.", tags={"Logging"}, operationId="getProjectJavascriptErrorLogs")
    public ShortLogResponse<ShortJavaScriptErrorLog> getAllShortLogs(PublicProjectId project, @BeanParam LogFilteringParameters logFilteringParameters) throws StorageException {
        return LogServiceUtils.getShortLogs((LogFilteringParameters)logFilteringParameters, this.openJavascriptErrorLogIndexes(project));
    }

    @Override
    @Operation(summary="Get JS error detail log", description="Returns the detailed JavaScript error log entry for the given timestamp.", tags={"Logging"}, operationId="getProjectJavascriptErrorLog")
    public DetailedJavaScriptErrorLog getDetailedLog(PublicProjectId project, LogEntryIdentifier logEntryIdentifier) throws StorageException {
        return (DetailedJavaScriptErrorLog)LogServiceUtils.getDetailedLogEntry(this.openJavascriptErrorLogIndexes(project), (LogEntryIdentifier)logEntryIdentifier);
    }

    @Override
    @Operation(summary="Get JS error frequencies", description="Returns the number of JavaScript error logs.", tags={"Logging"}, operationId="getProjectJavascriptErrorLogFrequencies")
    public List<ProjectLogLevelFrequencies> getLogFrequencies(PublicProjectId project) throws StorageException {
        return LogServiceUtils.obtainFrequencies(this.openJavascriptErrorLogIndexes(project));
    }

    @Override
    @Operation(summary="Download JS error logs", description="Returns a file download of the JavaScript error logs.", tags={"Logging"}, operationId="downloadProjectJavascriptErrorLogs")
    public Response downloadLog(PublicProjectId project, LogFilteringParameters logFilteringParameters, int maxChars) throws StorageException {
        return LogServiceUtils.createLogDownload((String)"TeamscaleJavaScriptErrorLogExport", (LogFilteringParameters)logFilteringParameters, (int)maxChars, this.openJavascriptErrorLogIndexes(project));
    }

    @Override
    @Operation(summary="Delete JS error logs", description="Deletes all log entries in the specified project that match the applied filters.", tags={"Logging"}, operationId="deleteProjectJavascriptErrorLogs")
    public void deleteLogEntries(PublicProjectId project, LogFilteringParameters logFilteringParameters) throws StorageException {
        LogServiceUtils.deleteLogEntries((LogFilteringParameters)logFilteringParameters, this.openJavascriptErrorLogIndexes(project));
        AuditLogs.projectLogDeletion((String)"JS error logs", (PublicProjectId)project);
    }

    private LogIndexesWrapper<ShortJavaScriptErrorLog, DetailedJavaScriptErrorLog> openJavascriptErrorLogIndexes(PublicProjectId project) throws StorageException {
        return new LogIndexesWrapper(PairList.from((Object)project, (Object)LogServiceUtils.determineIndexForProject((PublicProjectId)project, (IndexLayer)this.serviceInfo.getIndexLayer(), LogServiceUtils::getGlobalJavaScriptErrorLogIndex, LogServiceUtils::getProjectJavaScriptErrorLogIndex)));
    }
}

