/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.distribution;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.service.metrics.MetricServiceUtil;
import com.teamscale.service.metrics.distribution.MetricDistributionDelta;
import com.teamscale.service.metrics.distribution.MetricDistributionEntry;
import com.teamscale.service.metrics.distribution.MetricDistributionWithDelta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.math.MathUtils;
import org.conqat.lib.commons.math.Range;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class MetricDistributionProvider {
    private TreeMap<Double, Map<Integer, Double>> values = null;
    private Map<Integer, Double> totals = null;
    double minPrincipalMetricValue = Double.NEGATIVE_INFINITY;
    double maxPrincipalMetricValue = Double.POSITIVE_INFINITY;

    public List<MetricDistributionEntry> getMetricDistributionFor(UniformPath uniformPath, IMetricRetrievalStrategy metricRetrievalStrategy, HistoryAccessOption historyAccessOption, int principalMetricIndex, List<Integer> metricIndexes, List<Double> boundaries) throws StorageException {
        List<MetricDirectoryEntry> entries = MetricDistributionProvider.getMetricDirectoryEntries(uniformPath, historyAccessOption, metricRetrievalStrategy);
        Set<Integer> accessedMetricIndexes = MetricDistributionProvider.convertToIndexSet(principalMetricIndex, metricIndexes);
        List<MetricDirectoryEntry> leaves = MetricServiceUtil.extractCompleteLeaves(entries, accessedMetricIndexes);
        ArrayList<MetricDistributionEntry> metricsDistribution = this.createMetricDistribution(leaves, principalMetricIndex, metricIndexes, boundaries);
        double lowerBound = Math.min(this.minPrincipalMetricValue, MathUtils.min(boundaries));
        double upperBound = Math.max(this.maxPrincipalMetricValue, MathUtils.max(boundaries));
        return MetricDistributionProvider.trimToBounds(metricsDistribution, lowerBound, upperBound);
    }

    public MetricDistributionWithDelta getMetricDistributionWithDeltaFor(UniformPath uniformPath, IMetricRetrievalStrategy metricRetrievalStrategy, HistoryAccessOption startHistoryOption, HistoryAccessOption endHistoryOption, int principalMetricIndex, List<Integer> metricIndexes, List<Double> boundaries) throws StorageException {
        List<MetricDirectoryEntry> startEntries = MetricDistributionProvider.getMetricDirectoryEntries(uniformPath, startHistoryOption, metricRetrievalStrategy);
        Set<Integer> accessedMetricIndexes = MetricDistributionProvider.convertToIndexSet(principalMetricIndex, metricIndexes);
        List<MetricDirectoryEntry> startLeaves = MetricServiceUtil.extractCompleteLeaves(startEntries, accessedMetricIndexes);
        List<MetricDirectoryEntry> endEntries = MetricDistributionProvider.getMetricDirectoryEntries(uniformPath, endHistoryOption, metricRetrievalStrategy);
        List<MetricDirectoryEntry> endLeaves = MetricServiceUtil.extractCompleteLeaves(endEntries, accessedMetricIndexes);
        return this.createMetricDistributionWithDelta(startLeaves, endLeaves, principalMetricIndex, metricIndexes, boundaries);
    }

    private static List<MetricDirectoryEntry> getMetricDirectoryEntries(UniformPath uniformPath, HistoryAccessOption historyAccessOption, IMetricRetrievalStrategy metricRetrievalStrategy) throws StorageException {
        return new ArrayList<MetricDirectoryEntry>(metricRetrievalStrategy.getMetricDirectoryEntries(Collections.singletonList(uniformPath.toString()), historyAccessOption));
    }

    private MetricDistributionWithDelta createMetricDistributionWithDelta(List<MetricDirectoryEntry> startLeaves, List<MetricDirectoryEntry> endLeaves, int principalMetricIndex, List<Integer> metricIndexes, List<Double> boundaries) {
        ArrayList<MetricDistributionEntry> startMetricDistributions = this.createMetricDistribution(startLeaves, principalMetricIndex, metricIndexes, boundaries);
        double lowerBound = this.minPrincipalMetricValue;
        double upperBound = this.maxPrincipalMetricValue;
        ArrayList<MetricDistributionEntry> endMetricDistributions = this.createMetricDistribution(endLeaves, principalMetricIndex, metricIndexes, boundaries);
        lowerBound = Math.min(this.minPrincipalMetricValue, lowerBound);
        lowerBound = Math.min(lowerBound, MathUtils.min(boundaries));
        upperBound = Math.max(this.maxPrincipalMetricValue, upperBound);
        upperBound = Math.max(upperBound, MathUtils.max(boundaries));
        startMetricDistributions = MetricDistributionProvider.trimToBounds(startMetricDistributions, lowerBound, upperBound);
        endMetricDistributions = MetricDistributionProvider.trimToBounds(endMetricDistributions, lowerBound, upperBound);
        ArrayList<MetricDistributionDelta> metricDistributionDeltas = MetricDistributionProvider.calculateMetricDistributionDeltas(startMetricDistributions, endMetricDistributions);
        return new MetricDistributionWithDelta(metricDistributionDeltas, endMetricDistributions);
    }

    private ArrayList<MetricDistributionEntry> createMetricDistribution(List<MetricDirectoryEntry> entries, int principalMetricIndex, List<Integer> metricIndexes, List<Double> boundaries) {
        ArrayList<MetricDistributionEntry> result = new ArrayList<MetricDistributionEntry>();
        this.calculateDistributionAndBounds(entries, principalMetricIndex, metricIndexes, boundaries);
        double lowerBoundary = Double.NEGATIVE_INFINITY;
        for (double upperBoundary : this.values.keySet()) {
            Range range = new Range(lowerBoundary, false, upperBoundary, true);
            MetricDistributionEntry entry = new MetricDistributionEntry(range);
            Map<Integer, Double> valueMap = this.values.get(upperBoundary);
            for (Integer metricIndex : this.totals.keySet()) {
                entry.addValue(valueMap.get(metricIndex));
            }
            result.add(entry);
            lowerBoundary = upperBoundary;
        }
        return result;
    }

    private void calculateDistributionAndBounds(List<MetricDirectoryEntry> entries, int principalMetricIndex, List<Integer> metricIndexes, List<Double> boundaries) {
        this.initializeVariablesForCalculation(metricIndexes, boundaries);
        for (MetricDirectoryEntry entry : entries) {
            this.incrementValuesFor(entry, principalMetricIndex);
            Object value = entry.getValue(principalMetricIndex);
            if (!(value instanceof Double)) continue;
            this.minPrincipalMetricValue = Math.min(this.minPrincipalMetricValue, (Double)value);
            this.maxPrincipalMetricValue = Math.max(this.maxPrincipalMetricValue, (Double)value);
        }
    }

    private void initializeVariablesForCalculation(List<Integer> metricIndexes, List<Double> boundaries) {
        this.values = new TreeMap();
        this.totals = new HashMap<Integer, Double>();
        this.minPrincipalMetricValue = Double.POSITIVE_INFINITY;
        this.maxPrincipalMetricValue = Double.NEGATIVE_INFINITY;
        for (Double boundary : boundaries) {
            HashMap<Integer, Double> valueMap = MetricDistributionProvider.newValueMap(metricIndexes);
            this.values.put(boundary, valueMap);
        }
        this.values.put(Double.POSITIVE_INFINITY, MetricDistributionProvider.newValueMap(metricIndexes));
        for (Integer index : metricIndexes) {
            this.totals.put(index, 0.0);
        }
    }

    private static HashMap<Integer, Double> newValueMap(List<Integer> metricIndexes) {
        HashMap<Integer, Double> valueMap = new HashMap<Integer, Double>();
        for (Integer index : metricIndexes) {
            valueMap.put(index, 0.0);
        }
        return valueMap;
    }

    private void incrementValuesFor(MetricDirectoryEntry metricEntry, Integer principalMetricIndex) {
        double principalMetricValue = (Double)metricEntry.getValue(principalMetricIndex.intValue());
        Map<Integer, Double> valueMap = this.values.ceilingEntry(principalMetricValue).getValue();
        for (Integer metricIndex : this.totals.keySet()) {
            Double value = (Double)metricEntry.getValue(metricIndex.intValue());
            this.totals.put(metricIndex, value + this.totals.get(metricIndex));
            valueMap.put(metricIndex, value + valueMap.get(metricIndex));
        }
    }

    private static ArrayList<MetricDistributionDelta> calculateMetricDistributionDeltas(ArrayList<MetricDistributionEntry> startMetricDistributions, ArrayList<MetricDistributionEntry> endMetricDistributions) {
        ArrayList<MetricDistributionDelta> result = new ArrayList<MetricDistributionDelta>();
        for (int i = 0; i < startMetricDistributions.size(); ++i) {
            MetricDistributionDelta delta = MetricDistributionDelta.createDeltaFor(startMetricDistributions.get(i), endMetricDistributions.get(i));
            result.add(delta);
        }
        return result;
    }

    private static ArrayList<MetricDistributionEntry> trimToBounds(ArrayList<MetricDistributionEntry> entries, double lowerBound, double upperBound) {
        CCSMAssert.isTrue((lowerBound <= upperBound ? 1 : 0) != 0, (String)"Upper bound must be greater or equal to lower bound.");
        ArrayList<MetricDistributionEntry> result = new ArrayList<MetricDistributionEntry>();
        for (MetricDistributionEntry entry : entries) {
            double currentLowerBound = entry.getRange().getLower();
            double currentUpperBound = entry.getRange().getUpper();
            if (currentUpperBound < lowerBound || currentLowerBound > upperBound) continue;
            if (currentLowerBound >= lowerBound && currentUpperBound >= upperBound) {
                result.add(MetricDistributionProvider.resizeEntry(entry, currentLowerBound, upperBound));
                continue;
            }
            if (currentLowerBound <= lowerBound && currentUpperBound <= upperBound) {
                result.add(MetricDistributionProvider.resizeEntry(entry, lowerBound, currentUpperBound));
                continue;
            }
            result.add(entry);
        }
        return result;
    }

    private static MetricDistributionEntry resizeEntry(MetricDistributionEntry entry, double upperRangeBound, double lowerRangeBound) {
        Range trimmedRange = new Range(upperRangeBound, false, lowerRangeBound, true);
        MetricDistributionEntry entryWithResizedRange = new MetricDistributionEntry(trimmedRange);
        for (Double value : entry.getValues()) {
            entryWithResizedRange.addValue(value);
        }
        return entryWithResizedRange;
    }

    private static Set<Integer> convertToIndexSet(int principalMetricIndex, List<Integer> metricIndexes) {
        return Stream.concat(Stream.of(Integer.valueOf(principalMetricIndex)), metricIndexes.stream()).collect(Collectors.toSet());
    }
}

