/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.schema;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/metric-schema")
public class MetricSchemaService
extends ApiBase {
    @GET
    @Operation(summary="Get metric schema", description="Returns the metric schema for a project.")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public MetricDirectorySchema getMetricDirectorySchema() throws StorageException {
        return this.getMetricDirectorySchemaForPath(UniformPath.EType.CODE);
    }

    @GET
    @Path(value="{uniformPathType}")
    @Operation(summary="Get metric schema", description="Returns the metric schema for a path within a project.")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public MetricDirectorySchema getMetricDirectorySchemaForPath(@Parameter(description="The path for which the metric schema should be fetched") @PathParam(value="uniformPathType") UniformPath.EType uniformPathType) throws StorageException {
        return MetricSchemaService.getSchema(uniformPathType, this.getProjectStorageSystem(), this.getGlobalStorageSystem(), this.getUser());
    }

    public static MetricDirectorySchema getSchema(UniformPath.EType uniformPathType, CommitResolvingStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser) throws StorageException {
        MetricDirectorySchema metricDirectorySchema = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPathType, (ProjectStorageSystem)projectStorageSystem, (GlobalStorageSystem)globalStorageSystem, (User)currentUser, (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory((ProjectStorageSystem)projectStorageSystem)).getMetricDirectorySchema();
        if (metricDirectorySchema == null) {
            return MetricDirectorySchema.EMPTY;
        }
        return metricDirectorySchema;
    }
}

