/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Iterables;
import com.teamscale.core.analysis.configuration.index.model.MetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdGroup;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.architecture.ArchitectureAssessmentIndex;
import com.teamscale.index.merge_request.MetricAssessmentComputation;
import com.teamscale.index.metrics.assessment.MetricAssessment;
import com.teamscale.index.metrics.assessment.context.MetricDataRetrieverFactory;
import com.teamscale.index.metrics.threshold.MetricThresholdEvaluator;
import com.teamscale.index.resource.ExtendedResourceTypeIndex;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.resource.retrieval_strategy.IMetricDirectoryEntryRetriever;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.index.resource.retrieval_strategy.TestMetricRetrievalStrategy;
import com.teamscale.index.resource.utils.EResourceType;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.thresholds.ProjectThresholdConfigurationUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.base.SortAndPaginationOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.ReadCacheEnabled;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.issues.IssueContributor;
import com.teamscale.service.metrics.table.MetricTableServiceParameters;
import com.teamscale.service.metrics.table.MetricTableServiceUtils;
import com.teamscale.service.metrics.table.RootedList;
import com.teamscale.service.metrics.table.SinglePathDescriptor;
import com.teamscale.service.metrics.table.TableEntryBase;
import com.teamscale.service.metrics.threshold_path.MetricThresholdConfigurationIndexLastChangeContributor;
import com.teamscale.service.requirements_tracing.SpecItemContributor;
import com.teamscale.service.tests.TestQueriesLastUpdatedContributor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.compress.utils.Lists;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.AssessmentUtils;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.CounterSetSorting;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

@ReadCacheEnabled
@Path(value="api/projects/{project}/metrics/table")
@Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class, MetricThresholdConfigurationIndexLastChangeContributor.class, SpecItemContributor.class, IssueContributor.class, TestQueriesLastUpdatedContributor.class})
public class MetricTableService
extends ApiBase {
    private static final Comparator<CounterSet<Object>> ASSESSMENT_COMPARATOR = CounterSetSorting.comparator((Object[])ETrafficLightColor.values(), (Object[][])AssessmentUtils.ASSESSMENT_SORT_ORDER);
    private static final Comparator<CounterSet<Object>> TEST_GAP_COMPARATOR = CounterSetSorting.comparator((Object[])ETestGapState.values(), (Object[][])ETestGapState.TESTGAP_SORT_ORDER);

    @GET
    @Operation(summary="Get metric table", description="Retrieves a list of metric table entries for the given uniform path and its children.", tags={"Metrics"}, responses={@ApiResponse(responseCode="404", description="Metric threshold configuration could not be found. Metric is not known or not configured for project.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public MetricTablePage computeMetricTable(@BeanParam SortAndPaginationOptions sortAndPaginationOptions, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Uniform path to compute the metric table for") @QueryParam(value="uniform-path") UniformPath uniformPath, @BeanParam MetricTableServiceParameters parameters) throws StorageException {
        RootedList<MetricTableEntry> result = this.computeMetricTable(parameters, uniformPath, this.determineHistoryOption(commit));
        List<MetricTableEntry> sortedEntries = sortAndPaginationOptions.sortAndPaginate(result.children(), fieldName -> MetricTableService.createComparator(parameters.metricsToConsider, fieldName));
        return new MetricTablePage(result.root(), this.getArchitectureSummary(result), sortedEntries, sortedEntries.size());
    }

    private @Nullable MetricTableEntry getArchitectureSummary(RootedList<MetricTableEntry> from) {
        if (from.metaChildren().isEmpty()) {
            return null;
        }
        MetricTableEntry summary = (MetricTableEntry)Iterables.getOnlyElement(from.metaChildren());
        if (summary.relativePath.equals("-architecture-files-")) {
            return summary;
        }
        throw new IllegalStateException("Only expecting architecture entries as meta entries so far.");
    }

    private static Comparator<MetricTableEntry> createComparator(List<String> metricsToConsider, String fieldName) {
        int fieldIndex = metricsToConsider.indexOf(fieldName);
        if (fieldIndex == -1) {
            return MetricTableService.resourceTypeAndPathComparator();
        }
        return Comparator.nullsLast((entry1, entry2) -> {
            MetricAssessment metric1 = entry1.metrics.get(fieldIndex);
            MetricAssessment metric2 = entry2.metrics.get(fieldIndex);
            switch (metric1.getSchemaEntry().getValueType()) {
                case ASSESSMENT: {
                    return MetricTableService.compareAssessments(metric1, metric2);
                }
                case COUNTER_SET: {
                    return MetricTableService.compareCounterSet(metric1, metric2);
                }
            }
            return MetricTableService.compareOtherValueTypes(metric1, metric2);
        });
    }

    private static int compareAssessments(MetricAssessment metric1, MetricAssessment metric2) {
        if (metric1.getValue() instanceof Assessment && metric2.getValue() instanceof Assessment) {
            CounterSet set1 = ((Assessment)metric1.getValue()).toCounterSet();
            CounterSet set2 = ((Assessment)metric2.getValue()).toCounterSet();
            return ASSESSMENT_COMPARATOR.compare((CounterSet<Object>)set1, (CounterSet<Object>)set2);
        }
        if (metric1.getValue() instanceof CounterSet) {
            return ASSESSMENT_COMPARATOR.compare((CounterSet<Object>)((CounterSet)metric1.getValue()), (CounterSet<Object>)((CounterSet)metric2.getValue()));
        }
        throw new IllegalArgumentException("The metric assessment values are not comparable. Handle this!");
    }

    private static int compareCounterSet(MetricAssessment metric1, MetricAssessment metric2) {
        return TEST_GAP_COMPARATOR.compare((CounterSet<Object>)((CounterSet)metric1.getValue()), (CounterSet<Object>)((CounterSet)metric2.getValue()));
    }

    private static int compareOtherValueTypes(MetricAssessment metric1, MetricAssessment metric2) {
        if (metric1.getValue() == null) {
            return -1;
        }
        if (metric2.getValue() == null) {
            return 1;
        }
        if (metric1.getValue() == null && metric2.getValue() == null) {
            return 0;
        }
        if (metric1.getValue() instanceof Comparable && metric2.getValue() instanceof Comparable) {
            Comparable value1 = (Comparable)metric1.getValue();
            Comparable value2 = (Comparable)metric2.getValue();
            return value1.compareTo(value2);
        }
        throw new IllegalArgumentException("The metric value types are not comparable. Handle this!");
    }

    private static Comparator<MetricTableEntry> resourceTypeAndPathComparator() {
        return Comparator.nullsLast((entry1, entry2) -> {
            if (entry1.getResourceType() == null) {
                return 1;
            }
            if (entry2.getResourceType() == null) {
                return -1;
            }
            return entry1.getResourceType().compareTo((Enum)entry2.getResourceType());
        }).reversed().thenComparing(TableEntryBase::getRelativePath);
    }

    private RootedList<MetricTableEntry> computeMetricTable(MetricTableServiceParameters parameters, UniformPath uniformRootPath, HistoryAccessOption historyAccessOption) throws StorageException {
        MetricThresholdConfiguration thresholdConfiguration = MetricTableServiceUtils.loadThresholdConfiguration(parameters.thresholdConfigurationName, (IStorageInfo)this.serviceInfo, new MetricSchemaRetrieverFactory((ProjectStorageSystem)this.getProjectStorageSystem()));
        Set partitions = parameters.getPartitions().orElse(null);
        MetricDataRetrieverFactory metricDataRetrieverFactory = new MetricDataRetrieverFactory(partitions, (ProjectStorageSystem)this.getProjectStorageSystem(), this.getGlobalStorageSystem(), this.getUser(), new MetricSchemaRetrieverFactory((ProjectStorageSystem)this.getProjectStorageSystem()));
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformRootPath.getType(), (Set)partitions, (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser(), (boolean)true);
        RootedList<SinglePathDescriptor> pathDescriptors = this.collectPathsToProcess(uniformRootPath, historyAccessOption);
        return this.createEntriesForPaths(pathDescriptors, historyAccessOption, thresholdConfiguration, metricRetrievalStrategy, parameters.metricsToConsider, parameters.limitToProfile, metricDataRetrieverFactory, parameters.skipRowsWithoutData);
    }

    private RootedList<SinglePathDescriptor> collectPathsToProcess(UniformPath uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        RootedList<SinglePathDescriptor> result = MetricTableServiceUtils.collectAllSubPaths(uniformPath, historyAccessOption, (ProjectStorageSystem)this.getProjectStorageSystem());
        this.appendArchitectureSummary(uniformPath, historyAccessOption, result.metaChildren());
        return result;
    }

    private void appendArchitectureSummary(UniformPath rootPath, HistoryAccessOption historyAccessOption, List<SinglePathDescriptor> appendTo) throws StorageException {
        if (!rootPath.isCodePath() || !rootPath.isRoot()) {
            return;
        }
        ArchitectureAssessmentIndex architectureAssessmentIndex = (ArchitectureAssessmentIndex)this.getProjectStorageSystem().openProjectIndex(ArchitectureAssessmentIndex.class, historyAccessOption);
        if (!architectureAssessmentIndex.getAllAssessmentUniformPaths().isEmpty()) {
            appendTo.add(new SinglePathDescriptor(rootPath.toString(), "-architecture-files-", EResourceType.CONTAINER));
        }
    }

    private RootedList<MetricTableEntry> createEntriesForPaths(RootedList<SinglePathDescriptor> pathDescriptors, HistoryAccessOption historyAccessOption, MetricThresholdConfiguration thresholdConfiguration, IMetricRetrievalStrategy metricRetrievalStrategy, List<String> metricNames, boolean limitMetricsToProfile, MetricDataRetrieverFactory metricDataRetrieverFactory, boolean shouldSkipRowsWithoutData) throws StorageException {
        GlobalMetricEntryCreatorParameters metricParameters = new GlobalMetricEntryCreatorParameters(metricRetrievalStrategy, historyAccessOption, thresholdConfiguration, metricNames, limitMetricsToProfile);
        RootedList.RootedData withIsTestCodeClassification = pathDescriptors.bulkMap(iterable -> MetricTableServiceUtils.areTestCode(Lists.newArrayList(iterable.iterator()), (ExtendedResourceTypeIndex)this.getProjectStorageSystem().openProjectIndex(ExtendedResourceTypeIndex.class, historyAccessOption)));
        MetricAssessmentComputation assessmentComputation = this.buildAssessmentComputer(thresholdConfiguration, metricDataRetrieverFactory);
        MetricTableEntry summaryEntry = this.createRootMetricTableEntry(metricParameters, new CurrentMetricEntryCreatorParameters(pathDescriptors.root(), (Boolean)withIsTestCodeClassification.rootData()), assessmentComputation);
        Function createResultEntry = CollectionUtils.asSneakyFunction(element -> this.createMetricTableEntry(metricParameters, new CurrentMetricEntryCreatorParameters((SinglePathDescriptor)element.getKey(), (Boolean)element.getValue()), assessmentComputation));
        List<MetricTableEntry> childEntries = withIsTestCodeClassification.childEntries().map(createResultEntry).filter(Objects::nonNull).filter(entry -> !shouldSkipRowsWithoutData || !entry.getMetrics().stream().filter(metric -> metricNames.contains(metric.getMetricName())).allMatch(metric -> metric.getValue() == null)).toList();
        return new RootedList<MetricTableEntry>(summaryEntry, withIsTestCodeClassification.metaChildEntries().map(createResultEntry).toList(), childEntries);
    }

    private MetricAssessmentComputation buildAssessmentComputer(MetricThresholdConfiguration thresholdConfiguration, MetricDataRetrieverFactory metricDataRetrieverFactory) throws StorageException {
        MetricThresholdEvaluator thresholdConfigurationInterval = ProjectThresholdConfigurationUtils.getThresholdEvaluator((String)thresholdConfiguration.getName(), (IStorageInfo)this.serviceInfo, (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory((ProjectStorageSystem)this.getProjectStorageSystem()));
        return new MetricAssessmentComputation(thresholdConfigurationInterval, metricDataRetrieverFactory, (ProjectStorageSystem)this.getProjectStorageSystem(), this.getParallelTaskExecutor());
    }

    private static List<String> determineRelevantMetricNames(MetricDirectorySchema schema, List<String> passedMetricNames) {
        if (!passedMetricNames.isEmpty()) {
            return passedMetricNames;
        }
        return CollectionUtils.map((Collection)schema.getAllEntries(), MetricDirectorySchemaEntry::getName);
    }

    private @Nullable MetricTableEntry createRootMetricTableEntry(GlobalMetricEntryCreatorParameters globalParameters, CurrentMetricEntryCreatorParameters currentParameters, MetricAssessmentComputation assessmentComputation) throws StorageException {
        if (currentParameters.pathDescriptor.getUniformPath().equals(ArchitectureMetricsUtils.ROOT_PATH_TO_ARCHITECTURES) && this.noArchitectureExists(globalParameters.historyAccessOption)) {
            return new MetricTableEntry(currentParameters.pathDescriptor.getUniformPath(), Collections.emptyList(), currentParameters.pathDescriptor.getResourceType(), currentParameters.isClassifiedAsTestCode);
        }
        return this.createMetricTableEntry(globalParameters, currentParameters, assessmentComputation);
    }

    private boolean noArchitectureExists(HistoryAccessOption historyAccessOption) throws StorageException {
        return !this.projectIndexExists("architecture-assessment") || this.openProjectIndex(ArchitectureAssessmentIndex.class, historyAccessOption).getAllAssessmentUniformPaths().isEmpty();
    }

    private @Nullable MetricTableEntry createMetricTableEntry(GlobalMetricEntryCreatorParameters globalParameters, CurrentMetricEntryCreatorParameters currentParameters, MetricAssessmentComputation assessmentComputation) throws StorageException {
        MetricDirectoryEntry metricDirectoryEntry = globalParameters.metricDirectoryEntryRetriever.getMetricDirectoryEntry(currentParameters.pathDescriptor.getUniformPath());
        if (metricDirectoryEntry == null && globalParameters.isTestMetricRetrievalStrategy) {
            return null;
        }
        ArrayList<MetricAssessment> metricAssessments = new ArrayList<MetricAssessment>();
        for (String metricName : globalParameters.metricNames) {
            MetricAssessment metricAssessment = MetricTableServiceUtils.getMetricAssessmentFromThresholdConfiguration(currentParameters.pathDescriptor.getUniformPath(), globalParameters.historyAccessOption, globalParameters.thresholdConfiguration, metricName, assessmentComputation).orElse(null);
            if (metricAssessment == null) {
                if (globalParameters.limitMetricsToProfile && !globalParameters.enforcedMetricNamesForLimitedProfiles.contains(metricName)) continue;
                metricAssessment = MetricTableServiceUtils.getDefaultMetricAssessment(currentParameters.pathDescriptor.getUniformPath(), globalParameters.schema, metricName, metricDirectoryEntry);
            }
            metricAssessments.add(metricAssessment);
        }
        return new MetricTableEntry(currentParameters.pathDescriptor, metricAssessments, currentParameters.isClassifiedAsTestCode);
    }

    public record MetricTablePage(@JsonProperty(value="pathSummary") @Nullable MetricTableEntry pathSummary, @JsonProperty(value="architectureSummary") @Nullable MetricTableEntry architectureSummary, @JsonProperty(value="entries") List<MetricTableEntry> entries, @JsonProperty(value="totalAvailableEntries") int totalAvailableEntries) {
    }

    public static final class MetricTableEntry
    extends TableEntryBase<MetricAssessment> {
        @JsonProperty(value="metrics")
        public final List<MetricAssessment> metrics;

        private MetricTableEntry(String relativePath, List<MetricAssessment> values, EResourceType resourceType, boolean isTest) {
            super(relativePath, resourceType);
            this.isTest = isTest;
            this.metrics = values;
        }

        private MetricTableEntry(SinglePathDescriptor pathDescriptor, List<MetricAssessment> assessments, boolean isTest) {
            this(pathDescriptor.getRelativePath(), assessments, pathDescriptor.getResourceType(), isTest);
        }

        @JsonCreator
        public MetricTableEntry(@JsonProperty(value="relativePath") String relativePath, @JsonProperty(value="resourceType") EResourceType resourceType, @JsonProperty(value="metrics") List<MetricAssessment> values, @JsonProperty(value="isTest") boolean isTest) {
            this(relativePath, values, resourceType, isTest);
        }

        @Override
        protected Collection<MetricAssessment> getMetrics() {
            return this.metrics;
        }
    }

    private static class GlobalMetricEntryCreatorParameters {
        private final IMetricDirectoryEntryRetriever metricDirectoryEntryRetriever;
        private final HistoryAccessOption historyAccessOption;
        private final MetricThresholdConfiguration thresholdConfiguration;
        private final boolean isTestMetricRetrievalStrategy;
        private final boolean limitMetricsToProfile;
        private final List<String> metricNames;
        private final Set<String> enforcedMetricNamesForLimitedProfiles;
        private final MetricDirectorySchema schema;

        private GlobalMetricEntryCreatorParameters(IMetricRetrievalStrategy metricRetrievalStrategy, HistoryAccessOption historyAccessOption, MetricThresholdConfiguration thresholdConfiguration, List<String> metricNamesFromRequest, boolean limitMetricsToProfile) throws StorageException {
            this.historyAccessOption = historyAccessOption;
            this.thresholdConfiguration = thresholdConfiguration;
            this.limitMetricsToProfile = limitMetricsToProfile;
            this.schema = metricRetrievalStrategy.getMetricDirectorySchema();
            this.metricNames = MetricTableService.determineRelevantMetricNames(this.schema, metricNamesFromRequest);
            this.metricDirectoryEntryRetriever = metricRetrievalStrategy.getMetricDirectoryEntryRetriever(historyAccessOption);
            this.isTestMetricRetrievalStrategy = metricRetrievalStrategy instanceof TestMetricRetrievalStrategy;
            this.enforcedMetricNamesForLimitedProfiles = GlobalMetricEntryCreatorParameters.calculateThresholdConfigurationMetrics(thresholdConfiguration);
        }

        private static Set<String> calculateThresholdConfigurationMetrics(MetricThresholdConfiguration thresholdConfiguration) {
            HashSet<String> thresholdConfigurationMetrics = new HashSet<String>();
            for (MetricThresholdGroup metricThresholdGroup : thresholdConfiguration.getMetricThresholdGroups()) {
                for (MetricThreshold threshold : metricThresholdGroup.getMetricThresholdList()) {
                    thresholdConfigurationMetrics.add(threshold.getMetricName());
                }
            }
            return thresholdConfigurationMetrics;
        }
    }

    private record CurrentMetricEntryCreatorParameters(SinglePathDescriptor pathDescriptor, boolean isClassifiedAsTestCode) {
    }
}

