/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.treemap.builder;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.testgap.treemap.TreeMapNode;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderParameters;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import com.teamscale.service.metrics.treemap.builder.TreemapBuilderBase;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.color.ColorUtils;
import org.conqat.lib.commons.math.MathUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public abstract class MetricTreemapBuilderBase<T extends TreeMapNode>
extends TreemapBuilderBase<T> {
    private static final float GOLDEN_RATIO_CONJUGATE = 0.618034f;
    protected MetricTreemapBuilderParameters builderParameters;
    private Pair<Double, Double> colorMetricValueRange;
    private Map<String, Color> colorMap;

    protected MetricTreemapBuilderBase(IMetricRetrievalStrategy metricRetrievalStrategy, HistoryAccessOption historyAccessOption, int areaMetricIndex, MetricTreemapBuilderParameters parameters) {
        super(metricRetrievalStrategy, historyAccessOption, areaMetricIndex);
        this.builderParameters = parameters;
    }

    @Override
    protected void determineValueRange(List<MetricDirectoryEntry> entries) throws TreeMapBuilderException {
        this.colorMetricValueRange = this.determineValueRangeForColorMetric(entries);
        this.colorMap = this.determineColorMap(entries);
    }

    protected Pair<Double, Double> determineValueRangeForColorMetric(List<MetricDirectoryEntry> entries) throws TreeMapBuilderException {
        if (this.builderParameters.customMinimumValueDiffersFromDefault() && this.builderParameters.customMaximumValueDiffersFromDefault()) {
            Pair valueRange = new Pair((Object)this.builderParameters.getCustomMinValue(), (Object)this.builderParameters.getCustomMaxValue());
            MetricTreemapBuilderBase.assertValueRangeValid((Pair<Double, Double>)valueRange);
            return valueRange;
        }
        Pair<Double, Double> valueRangeFromMetric = this.determineValueRangeFromMetric(this.builderParameters.colorMetricIndex, entries);
        if (this.builderParameters.customMinimumValueDiffersFromDefault()) {
            Double customMinValue = Math.min(this.builderParameters.getCustomMinValue(), (Double)valueRangeFromMetric.getSecond());
            valueRangeFromMetric.setFirst((Object)customMinValue);
        }
        if (this.builderParameters.customMaximumValueDiffersFromDefault()) {
            Double customMaxValue = Math.max(this.builderParameters.getCustomMaxValue(), (Double)valueRangeFromMetric.getFirst());
            valueRangeFromMetric.setSecond((Object)customMaxValue);
        }
        if (((Double)valueRangeFromMetric.getFirst()).equals(valueRangeFromMetric.getSecond()) && !this.builderParameters.customMinimumValueDiffersFromDefault() && !this.builderParameters.customMaximumValueDiffersFromDefault()) {
            valueRangeFromMetric.setFirst((Object)0.0);
        }
        MetricTreemapBuilderBase.assertValueRangeValid(valueRangeFromMetric);
        return valueRangeFromMetric;
    }

    private Map<String, Color> determineColorMap(List<MetricDirectoryEntry> entries) {
        List values = entries.stream().map(entry -> {
            if (this.builderParameters.colorMetricIndex != -1) {
                return entry.getValueOrDefault(this.builderParameters.colorMetricIndex, this.builderParameters.colorMetricDefault);
            }
            return this.builderParameters.colorMetricDefault;
        }).flatMap(this::mapMetricValuesToStrings).distinct().filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
        return this.createColorMap(values);
    }

    private Map<String, Color> createColorMap(List<String> values) {
        values.sort(String::compareTo);
        float h = 0.1f;
        HashMap<String, Color> colorMap = new HashMap<String, Color>();
        for (String value : values) {
            h += 0.618034f;
            colorMap.put(value, Color.getHSBColor(h %= 1.0f, 0.5f, 0.95f));
        }
        return colorMap;
    }

    private Stream<String> mapMetricValuesToStrings(Object obj) {
        if (obj instanceof String) {
            String string = (String)obj;
            return Stream.of(string);
        }
        if (obj instanceof CounterSet) {
            CounterSet counterSet = (CounterSet)obj;
            return counterSet.getKeys().stream().map(key -> (String)key);
        }
        return Stream.empty();
    }

    protected Pair<Double, Double> determineValueRangeFromMetric(int metricIndex, List<MetricDirectoryEntry> entries) {
        MetricDirectoryEntry entry;
        Object value;
        double minimumValue = Double.MAX_VALUE;
        double maximumValue = 0.0;
        Iterator<MetricDirectoryEntry> iterator = entries.iterator();
        while (iterator.hasNext() && (value = (entry = iterator.next()).getValueOrDefault(metricIndex, (Object)0.0)) instanceof Number) {
            double doubleValue = ((Number)value).doubleValue();
            if (entry.hasChildren()) continue;
            if (doubleValue > maximumValue) {
                maximumValue = doubleValue;
            }
            if (!(doubleValue < minimumValue)) continue;
            minimumValue = doubleValue;
        }
        if (minimumValue == Double.MAX_VALUE && maximumValue == 0.0) {
            return new Pair((Object)0.0, (Object)0.0);
        }
        return new Pair((Object)minimumValue, (Object)maximumValue);
    }

    private static void assertValueRangeValid(Pair<Double, Double> valueRange) throws TreeMapBuilderException {
        Double minValue = (Double)valueRange.getFirst();
        Double maxValue = (Double)valueRange.getSecond();
        CCSMAssert.isNotNull((Object)minValue);
        CCSMAssert.isNotNull((Object)maxValue);
        if (minValue > maxValue) {
            throw new TreeMapBuilderException(String.format("The minimum value (%s) must be less than the maximum value (%s)", minValue, maxValue));
        }
    }

    @Override
    protected List<MetricDirectoryEntry> filterEntries(List<MetricDirectoryEntry> entries, String rootPath) {
        if (this.builderParameters.includePattern == null && this.builderParameters.excludePattern == null) {
            return entries;
        }
        return this.filterByIncludeExcludePattern(entries, rootPath);
    }

    protected List<MetricDirectoryEntry> filterByIncludeExcludePattern(List<MetricDirectoryEntry> entries, String rootPath) {
        HashMap<String, MetricDirectoryEntry> excludedEntries = new HashMap<String, MetricDirectoryEntry>();
        HashMap<String, MetricDirectoryEntry> includedEntries = new HashMap<String, MetricDirectoryEntry>();
        for (MetricDirectoryEntry metricDirectoryEntry : entries) {
            String uniformPath = metricDirectoryEntry.getUniformPath();
            if (uniformPath.equals(rootPath) || StringUtils.isEmpty((String)uniformPath) || !metricDirectoryEntry.hasChildren() && this.isIncluded(uniformPath)) {
                includedEntries.put(uniformPath, metricDirectoryEntry);
                MetricTreemapBuilderBase.includeParentIfNeeded(excludedEntries, includedEntries, uniformPath);
                continue;
            }
            excludedEntries.put(uniformPath, metricDirectoryEntry);
        }
        return new ArrayList<MetricDirectoryEntry>(includedEntries.values());
    }

    protected boolean isIncluded(String uniformPath) {
        if (this.builderParameters.excludePattern != null && this.builderParameters.excludePattern.matcher(uniformPath).matches()) {
            return false;
        }
        return this.builderParameters.includePattern == null || this.builderParameters.includePattern.matcher(uniformPath).matches();
    }

    private static void includeParentIfNeeded(Map<String, MetricDirectoryEntry> excludedEntries, Map<String, MetricDirectoryEntry> includedEntries, String uniformPath) {
        String[] paths = UniformPathUtils.splitPath((String)uniformPath);
        ArrayList<String> parentPaths = new ArrayList<String>(paths.length);
        for (String path : paths) {
            parentPaths.add(path);
            String parentPath = StringUtils.concat(parentPaths, (String)UniformPathUtils.SEPARATOR);
            if (includedEntries.containsKey(parentPath) || !excludedEntries.containsKey(parentPath)) continue;
            includedEntries.put(parentPath, excludedEntries.get(parentPath));
        }
    }

    protected @Nullable Color determineColor(MetricDirectoryEntry entry) throws StorageException {
        if (entry.hasChildren()) {
            return null;
        }
        if (this.builderParameters.colorMetricIndex < 0) {
            return this.builderParameters.baseColor;
        }
        Object value = entry.getValueOrDefault(this.builderParameters.colorMetricIndex, this.builderParameters.colorMetricDefault);
        if (value instanceof Assessment) {
            return this.determineColorForAssessment((Assessment)value, ((MetricDirectorySchema)this.metricDirectorySchemaSupplier.get()).getEntry(this.builderParameters.colorMetricIndex));
        }
        if (value instanceof Number) {
            return this.determineColorForNumber((Number)value);
        }
        if (value instanceof String) {
            return this.colorMap.get(value);
        }
        if (value instanceof CounterSet) {
            CounterSet counterSet = (CounterSet)value;
            String key = counterSet.getKeys().stream().findFirst().orElse(null);
            if (key != null) {
                return this.colorMap.get(key);
            }
            return this.builderParameters.baseColor;
        }
        throw new AssertionError((Object)"Should not happen as we checked metric type before.\nMetric: %s (type: %s)\nEntry: %s\nIndex: %d\n".formatted(value, Optional.ofNullable(value).map(Object::getClass).orElse(null), entry, this.builderParameters.colorMetricIndex));
    }

    private Color determineColorForAssessment(Assessment assessment, MetricDirectorySchemaEntry entry) {
        ETrafficLightColor color = assessment.getDominantColor();
        if (color == null) {
            return Color.GRAY;
        }
        if (assessment.getSize() == 0) {
            if (entry.hasProperty(EMetricProperty.EMPTY_ASSESSMENT_IS_NEUTRAL)) {
                return Color.GRAY;
            }
            color = ETrafficLightColor.GREEN;
        }
        return color.getColor(this.builderParameters.isColorBlindModeEnabled());
    }

    protected Color determineColorForNumber(Number value) {
        double range = (Double)this.colorMetricValueRange.getSecond() - (Double)this.colorMetricValueRange.getFirst();
        double relativeValue = 0.0;
        if (range > 0.0) {
            relativeValue = (value.doubleValue() - (Double)this.colorMetricValueRange.getFirst()) / range;
            relativeValue = MathUtils.constrainValue((double)relativeValue, (double)0.0, (double)1.0);
        }
        return ColorUtils.blend((double)relativeValue, (Color)this.builderParameters.baseColor, (Color)Color.WHITE);
    }

    protected String formatMetricValue(Object value) {
        if (value instanceof CounterSet) {
            CounterSet counterSet = (CounterSet)value;
            return counterSet.getKeys().stream().filter(Objects::nonNull).map(String.class::cast).filter(s -> !s.isBlank()).sorted().collect(Collectors.joining(", "));
        }
        return value.toString();
    }
}

