/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.treemap.builder;

import com.teamscale.service.issues.EFileBasedSummaryType;
import java.util.DoubleSummaryStatistics;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class TreemapSummaryUtils {
    public static DoubleSummaryStatistics calculateStatisticsToAdd(EFileBasedSummaryType summaryType, double violationThreshold, boolean lowIsViolating, double colorMetricValue, Double areaMetricValue) {
        boolean isViolating = lowIsViolating && colorMetricValue <= violationThreshold || !lowIsViolating && colorMetricValue >= violationThreshold;
        return switch (summaryType) {
            default -> throw new MatchException(null, null);
            case EFileBasedSummaryType.AVERAGE_BASED -> new DoubleSummaryStatistics(areaMetricValue.longValue(), colorMetricValue, colorMetricValue, colorMetricValue * areaMetricValue);
            case EFileBasedSummaryType.NODE_BASED -> new DoubleSummaryStatistics(1L, 0.0, 1.0, isViolating ? 1.0 : 0.0);
            case EFileBasedSummaryType.AREA_BASED -> new DoubleSummaryStatistics(areaMetricValue.longValue(), 0.0, areaMetricValue, isViolating ? areaMetricValue : 0.0);
        };
    }

    private TreemapSummaryUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

