/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.monitoring.prometheus.collectors;

import com.teamscale.core.index.CriticalSystemStateIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.service.monitoring.prometheus.collectors.IndexCallbackMetricsProviderBase;
import io.prometheus.metrics.core.metrics.GaugeWithCallback;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;

public class CriticalSystemStateCollector
extends IndexCallbackMetricsProviderBase {
    private static final Logger LOGGER = LogManager.getLogger();

    public CriticalSystemStateCollector(IndexLayer indexLayer) {
        super(indexLayer);
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("critical_system_event")).help("Count of currently active critical system events.")).labelNames(new String[]{"type"})).callback(this::collectCriticalSystemStates).register();
    }

    private void collectCriticalSystemStates(GaugeWithCallback.Callback cb) {
        try {
            CriticalSystemStateIndex criticalSystemStateIndex = (CriticalSystemStateIndex)this.indexLayer.openGlobalIndex(CriticalSystemStateIndex.class);
            CriticalSystemStateIndex.CriticalSystemStatus status = criticalSystemStateIndex.getStatus();
            Set types = Arrays.stream(CriticalSystemStateIndex.ECriticalSystemStatusType.values()).collect(Collectors.toCollection(HashSet::new));
            if (status != null) {
                cb.call(1.0, new String[]{status.getStatusType().name().toLowerCase()});
                types.remove(status.getStatusType());
            }
            for (CriticalSystemStateIndex.ECriticalSystemStatusType type : types) {
                cb.call(0.0, new String[]{type.name().toLowerCase()});
            }
        }
        catch (StorageException e) {
            LOGGER.error("Could not collect critical system states.", (Throwable)e);
        }
    }
}

