/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.index.repository.retrievers.FilesRetrieverFactory;
import com.teamscale.index.repository.retrievers.IFilesRetriever;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.project.RepositoryPreviewServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectIdBase;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Path(value="api/files-retriever")
public class FilesRetrieverService
extends RepositoryPreviewServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @POST
    @Operation(summary="Retrieves files from VCSs", description="Returns list of all files for a given VCS connector existing on the default branch at HEAD", responses={@ApiResponse(responseCode="400", description="Indicates problems with user input or project configuration.")})
    @RequiresNoPermission
    public Collection<String> previewRepositoryFiles(@RequestBody ConnectorConfiguration connectorConfiguration, @Parameter(description="The id of the project to which the connector configuration belongs") @QueryParam(value="projectId") PublicProjectId projectId) throws StorageException, RepositoryException, ServiceCallException {
        return this.previewValues(connectorConfiguration, projectId);
    }

    @Override
    protected Collection<String> retrieveValuesFromRepository(boolean projectExists, @Nullable PublicProjectId projectId, @Nullable ExternalCredentials credentials, @NonNull ConnectorConfiguration connectorConfiguration) throws StorageException, RepositoryException, ProjectConfigurationException {
        return this.retrieveFilesLocked(projectId, this.createFilesRetriever(projectId, credentials, connectorConfiguration));
    }

    private @NonNull IFilesRetriever createFilesRetriever(@Nullable PublicProjectId projectId, @Nullable ExternalCredentials credentials, @NonNull ConnectorConfiguration connectorConfiguration) throws StorageException, RepositoryException {
        return new FilesRetrieverFactory(this.getIndexLayer(), LOGGER).getFilesRetriever((IProjectId)projectId, this.serviceInfo.getUser(), () -> Objects.requireNonNull(credentials), connectorConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @NonNull Collection<@NonNull String> retrieveFilesLocked(PublicProjectId projectId, IFilesRetriever filesRetriever) throws RepositoryException, ProjectConfigurationException {
        Lock repositoryLock = this.serviceInfo.getLockProvider().obtainLock(Optional.ofNullable(projectId).map(ProjectIdBase::toString).orElse(""));
        repositoryLock.lock();
        try {
            Collection collection = filesRetriever.fetchFiles();
            return collection;
        }
        finally {
            repositoryLock.unlock();
        }
    }
}

