/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.utils.ProjectUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.EComplexPermission;
import com.teamscale.service.framework.authorization.RequiresComplexPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/credentials")
public class ProjectCredentialsService
extends ApiBase {
    @GET
    @Operation(summary="Get project credentials", description="Returns the names of credentials that are assigned to the given Teamscale projects.", tags={"Project", "External Accounts"})
    @RequiresComplexPermission(value=EComplexPermission.MAY_CONFIGURE_EXTERNAL_CREDENTIALS)
    public ExternalCredentialsUsageInfo getProjectCredentials(@QueryParam(value="project") List<PublicProjectId> projects) throws StorageException {
        return this.getCredentialsUsageInfo(projects);
    }

    private ExternalCredentialsUsageInfo getCredentialsUsageInfo(List<PublicProjectId> projects) throws StorageException {
        ExternalCredentialsUsageInfo result = new ExternalCredentialsUsageInfo();
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        List projectEntries = projectIndex.resolveProjects(projects);
        for (int i = 0; i < projects.size(); ++i) {
            PublicProjectId project = projects.get(i);
            ProjectInfo projectEntry = (ProjectInfo)projectEntries.get(i);
            if (projectEntry == null || projectEntry.isDeletingOrReanalyzing()) {
                result.hadProjectsInReanalysisState = true;
                continue;
            }
            if (!this.getPermissions().userHasProjectPermission((IProjectId)project, EProjectPermission.VIEW)) {
                result.projectsMissingBecauseOfPermissions = true;
                continue;
            }
            ProjectConfiguration projectConfig = ProjectUtils.retrieveProjectConfig((IProjectId)projectIndex.resolveToInternalId((IProjectId)project), (IndexLayer)this.getIndexLayer());
            for (String accountIdentifier : ProjectCredentialsService.extractAccountIdentifiers(projectConfig)) {
                result.credentialToProjects.computeIfAbsent(accountIdentifier, x -> new ArrayList()).add(project);
            }
        }
        return result;
    }

    private static List<String> extractAccountIdentifiers(ProjectConfiguration projectConfig) {
        HashSet<String> accountIdentifiers = new HashSet<String>();
        for (ConnectorConfiguration connector : projectConfig.getConnectors()) {
            String accountIdentifier = connector.getOptionValue("Account");
            if (accountIdentifier == null) continue;
            accountIdentifiers.add(accountIdentifier);
        }
        return new ArrayList<String>(accountIdentifiers);
    }

    public static class ExternalCredentialsUsageInfo {
        @JsonProperty(value="projectsMissingBecauseOfPermissions")
        private boolean projectsMissingBecauseOfPermissions;
        @JsonProperty(value="hadProjectsInReanalysisState")
        private boolean hadProjectsInReanalysisState;
        @JsonProperty(value="credentialToProjects")
        private final Map<String, List<PublicProjectId>> credentialToProjects = new HashMap<String, List<PublicProjectId>>();
    }
}

