/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project.analysis_profile;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.configuration.tools.message.SonarLintMessageManager;
import com.teamscale.index.findings.sonarlint.SonarLintRulesExtractor;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.project.analysis_profile.AnalysisProfileImportServiceUtils;
import com.teamscale.service.project.analysis_profile.AnalysisProfileImportUtils;
import eu.cqse.check.framework.core.CheckInfo;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.registry.CheckMapping;
import eu.cqse.check.framework.core.registry.CheckRegistry;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.xml.XMLUtils;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Path(value="api/import-sonar-profile")
public class SonarQualityProfileImportService
extends ApiBase {
    private final SonarQualityProfileImportSummary summary = new SonarQualityProfileImportSummary();

    @POST
    @Operation(summary="Upload Sonar profile", description="Uploads Sonar Quality Profiles which are then converted to Teamscale analysis profiles. Returns a textual summary of the import process", tags={"Analysis profiles"})
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_ANALYSIS_PROFILES})
    @Consumes(value={"multipart/form-data"})
    public SonarQualityProfileImportSummary importSonarProfile(@Parameter(required=true, schema=@Schema(type="string", format="binary")) @FormDataParam(value="profile") FormDataBodyPart profile, @BeanParam SonarQualityProfileImportParameters parameters) throws IOException, SAXException, ProjectConfigurationException, ConQATException {
        Map groupToQualityIndicatorMapping = SonarLintMessageManager.getInstance().getGroupToQualityIndicatorMapping();
        Map<String, EFindingEnablement> enablementMapping = parameters.getEnablementMapping();
        Document document = XMLUtils.parse((InputSource)new InputSource((InputStream)profile.getEntityAs(InputStream.class)));
        Element documentElement = document.getDocumentElement();
        this.importSonarProfile(enablementMapping, documentElement, parameters.enableTeamscaleDefaults, groupToQualityIndicatorMapping);
        return this.summary;
    }

    private void importSonarProfile(Map<String, EFindingEnablement> enablementMapping, Element documentElement, boolean enableTeamscaleDefaults, Map<String, String> groupToQualityIndicatorMapping) throws ProjectConfigurationException, ConQATException {
        ELanguage language = SonarQualityProfileImportService.determineLanguage(documentElement);
        Set<ELanguage> languages = Set.of(language);
        if (!EAnalysisTool.SONAR_LINT.isAvailableAndSupportsOneOf(languages)) {
            throw new BadRequestException("Language " + language.getReadableName() + " not supported by Teamscale's SonarLint integration");
        }
        ConfigurationTemplate template = AnalysisProfileImportUtils.createConfigurationTemplate(EAnalysisTool.SONAR_LINT, languages, enableTeamscaleDefaults, groupToQualityIndicatorMapping, this.getGlobalStorageSystem());
        String profileName = SonarQualityProfileImportService.getTextContentOfNamedChild(documentElement, "name");
        AnalysisProfile analysisProfile = new AnalysisProfile(profileName, languages, Set.of(EAnalysisTool.SONAR_LINT));
        AnalysisProfileUtils.createQualityIndicators((AnalysisProfile)analysisProfile, (ConfigurationTemplate)template);
        AnalysisProfileUtils.createGlobalOptions((AnalysisProfile)analysisProfile, (ConfigurationTemplate)template);
        Element rulesElement = XMLUtils.getNamedChild((Element)documentElement, (String)"rules");
        Map<String, EFindingEnablement> enablementByRuleId = SonarQualityProfileImportService.getEnablementMapping(enablementMapping, Objects.requireNonNull(rulesElement));
        this.summary.overallChecks = enablementByRuleId.size();
        this.enableRules(enablementByRuleId, language, analysisProfile, enableTeamscaleDefaults, template);
        AnalysisProfileImportServiceUtils.writeProfile(analysisProfile, this.getGlobalStorageSystem(), this.getPermissions());
        this.summary.profileName = profileName;
    }

    private static ELanguage determineLanguage(Element documentElement) {
        String languageName = SonarQualityProfileImportService.getTextContentOfNamedChild(documentElement, "language");
        if (languageName.equalsIgnoreCase("js")) {
            return ELanguage.JAVASCRIPT;
        }
        ELanguage language = (ELanguage)EnumUtils.valueOfIgnoreCase(ELanguage.class, (String)languageName);
        if (language == null) {
            throw new BadRequestException("Language " + languageName + " not supported");
        }
        return language;
    }

    private void enableRules(Map<String, EFindingEnablement> enablementByRuleId, ELanguage language, AnalysisProfile analysisProfile, boolean enableTeamscaleDefaults, ConfigurationTemplate configurationTemplate) throws ProjectConfigurationException {
        Map<String, AnalysisGroup> analysisGroupsByName = AnalysisProfileImportUtils.getAnalysisGroupsByName(analysisProfile);
        HashSet<String> usedRuleIds = new HashSet<String>();
        HashSet<String> activatedRules = new HashSet<String>();
        SonarQualityProfileImportService.activateSonarLintRules(language, enablementByRuleId, usedRuleIds, activatedRules, analysisGroupsByName);
        SonarQualityProfileImportService.activateTeamscaleChecks(language, enablementByRuleId, usedRuleIds, activatedRules, analysisGroupsByName);
        if (!enableTeamscaleDefaults) {
            AnalysisProfileImportServiceUtils.disableTeamscaleDefaultChecks(analysisGroupsByName.values(), configurationTemplate, activatedRules);
        }
        this.summary.importedChecks = activatedRules.size();
        this.summary.unsupportedChecks = new ArrayList<String>(CollectionUtils.subtract(enablementByRuleId.keySet(), usedRuleIds));
    }

    private static void activateSonarLintRules(ELanguage language, Map<String, EFindingEnablement> enablementByRuleId, Set<String> usedRuleIds, Set<String> activatedRules, Map<String, AnalysisGroup> analysisGroupsByName) throws ProjectConfigurationException {
        for (CheckMapping rule : SonarLintMessageManager.getInstance().getRules()) {
            if (SonarLintMessageManager.getRuleLanguage((String)rule.checkId) != language || rule.defaultEnablement == null) continue;
            usedRuleIds.add(rule.checkId);
            EFindingEnablement enablement = enablementByRuleId.get(rule.checkId);
            if (enablement == null) continue;
            activatedRules.add(rule.checkId);
            analysisGroupsByName.get(SonarLintMessageManager.getInstance().getFindingsGroupNameFor(rule.checkId)).setOptionValue(rule.checkId, enablement.toString());
        }
    }

    private static void activateTeamscaleChecks(ELanguage language, Map<String, EFindingEnablement> enablementByRuleId, Set<String> usedRuleIds, Set<String> activatedRules, Map<String, AnalysisGroup> analysisGroupsByName) {
        for (CheckInfo rule : CheckRegistry.getInstance().getChecksInfos()) {
            if (!rule.getSupportedLanguages().contains(language) || rule.getDefaultEnablement() == null) continue;
            usedRuleIds.add(rule.getId());
            EFindingEnablement enablement = enablementByRuleId.get(rule.getId());
            if (enablement == null) continue;
            activatedRules.add(rule.getId());
            analysisGroupsByName.get(SonarLintMessageManager.getInstance().getFindingsGroupNameFor(rule.getId())).setOptionValue(rule.getId(), enablement.toString());
        }
    }

    private static Map<String, EFindingEnablement> getEnablementMapping(Map<String, EFindingEnablement> enablementMapping, Element rulesElement) throws ConQATException {
        Map deprecatedRuleKeysMapping = SonarLintRulesExtractor.getDeprecatedRuleKeysMapping();
        HashMap<String, EFindingEnablement> enablementByRuleId = new HashMap<String, EFindingEnablement>();
        for (Element ruleElement : XMLUtils.elementNodes((NodeList)rulesElement.getChildNodes())) {
            String repositoryKey = Objects.requireNonNull(XMLUtils.getNamedChild((Element)ruleElement, (String)"repositoryKey")).getTextContent();
            Object ruleKey = repositoryKey + ":" + Objects.requireNonNull(XMLUtils.getNamedChild((Element)ruleElement, (String)"key")).getTextContent();
            if (deprecatedRuleKeysMapping.containsKey(ruleKey)) {
                ruleKey = (String)deprecatedRuleKeysMapping.get(ruleKey);
            }
            ruleKey = ((String)ruleKey).replace("S00", "S");
            Element priorityElement = XMLUtils.getNamedChild((Element)ruleElement, (String)"priority");
            String priority = Objects.requireNonNull(priorityElement).getTextContent();
            enablementByRuleId.put((String)ruleKey, enablementMapping.get(priority.toLowerCase()));
        }
        return enablementByRuleId;
    }

    private static String getTextContentOfNamedChild(Element element, String childName) {
        return Objects.requireNonNull(XMLUtils.getNamedChild((Element)element, (String)childName)).getTextContent();
    }

    public static class SonarQualityProfileImportSummary {
        @JsonProperty(value="importedChecks")
        private int importedChecks;
        @JsonProperty(value="overallChecks")
        private int overallChecks;
        @JsonProperty(value="unsupportedChecks")
        private List<String> unsupportedChecks;
        @JsonProperty(value="profileName")
        private String profileName;
    }

    private static class SonarQualityProfileImportParameters {
        @FormDataParam(value="info-enablement")
        private EFindingEnablement infoEnablement;
        @FormDataParam(value="minor-enablement")
        private EFindingEnablement minorEnablement;
        @FormDataParam(value="major-enablement")
        private EFindingEnablement majorEnablement;
        @FormDataParam(value="critical-enablement")
        private EFindingEnablement criticalEnablement;
        @FormDataParam(value="blocker-enablement")
        private EFindingEnablement blockerEnablement;
        @FormDataParam(value="enable-teamscale-defaults")
        private boolean enableTeamscaleDefaults;

        private Map<String, EFindingEnablement> getEnablementMapping() {
            HashMap<String, EFindingEnablement> enablementMapping = new HashMap<String, EFindingEnablement>();
            enablementMapping.put("info", this.infoEnablement);
            enablementMapping.put("minor", this.minorEnablement);
            enablementMapping.put("major", this.majorEnablement);
            enablementMapping.put("critical", this.criticalEnablement);
            enablementMapping.put("blocker", this.blockerEnablement);
            return enablementMapping;
        }
    }
}

