/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.lang.ToStringHelpers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.index.shared.GitRefUtils;

@Deprecated
public class Legacy64BranchesInfo {
    @JsonProperty(value="mainBranchName")
    private final String mainBranchName;
    @JsonProperty(value="branchNames")
    private final List<String> branchNames = new ArrayList<String>();
    @JsonProperty(value="deletedBranches")
    private final List<String> deletedBranches = new ArrayList<String>();
    @JsonProperty(value="anonymousBranches")
    private final List<String> anonymousBranches = new ArrayList<String>();
    @JsonProperty(value="aliases")
    private final Map<String, String> aliases = new HashMap<String, String>();
    @JsonProperty(value="recentBranches")
    private final List<String> recentBranches = new ArrayList<String>();

    public Legacy64BranchesInfo() {
        this("", Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public Legacy64BranchesInfo(String defaultBranchName, List<String> branchNames, List<String> deletedBranches, List<String> recentBranches) {
        this.mainBranchName = defaultBranchName;
        this.copyNonAnonymousBranches(branchNames, this.branchNames);
        this.copyNonAnonymousBranches(deletedBranches, this.deletedBranches);
        this.recentBranches.addAll(recentBranches);
    }

    private void copyNonAnonymousBranches(List<String> sourceBranches, List<String> targetBranches) {
        for (String branchName : sourceBranches) {
            if (GitRefUtils.isAnonymousBranchName((String)branchName)) {
                this.anonymousBranches.add(branchName);
                continue;
            }
            targetBranches.add(branchName);
        }
    }

    public void addBranchAlias(String branch, String alias) {
        this.aliases.put(branch, alias);
    }

    public Map<String, String> getAliases() {
        return Collections.unmodifiableMap(this.aliases);
    }

    public String getDefaultBranchName() {
        return this.mainBranchName;
    }

    public List<String> getActiveBranchNames() {
        return this.branchNames;
    }

    public List<String> getAllBranchNames() {
        ArrayList<String> allBranchNames = new ArrayList<String>(this.branchNames);
        if (this.deletedBranches != null) {
            allBranchNames.addAll(this.deletedBranches);
        }
        if (this.anonymousBranches != null) {
            allBranchNames.addAll(this.anonymousBranches);
        }
        return allBranchNames;
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }
}

