/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.trigger.debug;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.impl.analysis.TriggerIndex;
import com.teamscale.core.runtime.impl.analysis.trigger.AnalysisTrigger;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompiler;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.system.trigger.debug.TriggerGraphService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;

@Path(value="api/projects/{project}/triggers/debug/graph/slice")
public class TriggerGraphSliceService
extends ApiBase {
    @VisibleForTesting
    static final String INCLUDE_INDICES_PARAMETER = "include-indexes";
    @VisibleForTesting
    static final String FORWARD_SLICE_PARAMETER = "forward-slice";
    @VisibleForTesting
    static final String SLICE_NODES_PARAMETER = "slice-nodes";

    @GET
    @Operation(summary="Get visualization of the trigger graph", description="Retrieves a visualization of the trigger graph. The service returns the graph in dot format (graph viz). To render a picture from that, I recommend online tools (e.g., https://stamm-wilbrandt.de/GraphvizFiddle/).\n\nIf you specified a slice node, but get an empty graph, we could probably not match the given string to a node. Download a complete graph and copy the name from there.", tags={"Debugging"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public String generateGraph(@Parameter(description="If this parameter is 'true', then the read/written indexes are included in the graph.") @QueryParam(value="include-indexes") boolean includeIndexes, @Parameter(description="Names of nodes in the graph that should be used to start slicing. This can be trigger names or index names. To slice by index, use the index name, not the index-class name (e.g., check-phase-dependencies, not CheckPhaseResultDependencyIndex). All nodes that are not forward/backward reachable from these nodes are not displayed.Nodes are matched exact, so provide the exact names of triggers/indexes that you want to be included.If the list is empty, the complete graph is returned.") @QueryParam(value="slice-nodes") List<String> sliceNodes, @Parameter(description="If true (forward slicing), only nodes influenced by the slice nodes are returned (i.e., nodes that are executed \"after\" the slice nodes). If false (backward slicing), we return only nodes that influence one of the slice nodes.") @QueryParam(value="forward-slice") boolean forwardSlice) throws StorageException {
        try {
            return this.createTriggerGraph(includeIndexes, sliceNodes, forwardSlice);
        }
        catch (TriggerCompilationException e) {
            throw new InternalServerErrorException("Failed to construct the trigger graph.", (Throwable)e);
        }
    }

    private String createTriggerGraph(boolean includeIndices, List<String> sliceNodes, boolean forwardSlice) throws StorageException, TriggerCompilationException {
        List<AnalysisTrigger> triggers;
        PairList rawTriggers = this.openProjectIndex(TriggerIndex.class, null).getAllTriggers();
        List<AnalysisTrigger> remainingTriggers = triggers = new TriggerCompiler(this.getProjectStorageSystem().getSchema(), this.getGlobalStorageSystem().getSchema()).compile(rawTriggers);
        if (!sliceNodes.isEmpty()) {
            remainingTriggers = TriggerGraphSliceService.limitToSlice(triggers, sliceNodes, forwardSlice);
        }
        StringBuilder builder = new StringBuilder("digraph {" + StringUtils.LINE_SEPARATOR);
        builder.append("subgraph cluster_triggers { label=\"Triggers\";" + StringUtils.LINE_SEPARATOR);
        TriggerGraphService.addTriggerNodes(remainingTriggers, builder);
        builder.append("}" + StringUtils.LINE_SEPARATOR);
        TriggerGraphSliceService.addTriggerDeltaEdges(remainingTriggers, builder);
        if (includeIndices) {
            TriggerGraphSliceService.addTriggerGraphIndexes(remainingTriggers, builder);
            TriggerGraphService.addTriggerToIndexEdges(remainingTriggers, builder);
        }
        builder.append("}" + StringUtils.LINE_SEPARATOR);
        return builder.toString();
    }

    static List<AnalysisTrigger> limitToSlice(List<AnalysisTrigger> triggers, List<String> sliceNodeNames, boolean forwardSlice) {
        ArrayList<AnalysisTrigger> spawnTriggers = new ArrayList<AnalysisTrigger>(CollectionUtils.filter(triggers, trigger -> sliceNodeNames.contains(trigger.getName())));
        for (AnalysisTrigger trigger2 : triggers) {
            for (String store : trigger2.getWriteStores()) {
                if (!sliceNodeNames.contains(store)) continue;
                spawnTriggers.add(trigger2);
            }
        }
        if (forwardSlice) {
            for (AnalysisTrigger trigger2 : triggers) {
                for (String store : CollectionUtils.unionSet((Collection)trigger2.getReadBranchingLayerStores(), (Collection[])new Collection[]{trigger2.getReadOnlyStores(), trigger2.getReadStores()})) {
                    if (!sliceNodeNames.contains(store)) continue;
                    spawnTriggers.add(trigger2);
                }
            }
        }
        Map<AnalysisTrigger, Set<AnalysisTrigger>> edgeMap = TriggerGraphSliceService.getEdgeMap(triggers, forwardSlice);
        Set<AnalysisTrigger> slice = TriggerGraphSliceService.computeSlice(spawnTriggers, edgeMap);
        return CollectionUtils.sort(slice, Comparator.comparing(AnalysisTrigger::getName));
    }

    private static @NonNull Set<AnalysisTrigger> computeSlice(List<AnalysisTrigger> spawnTriggers, Map<AnalysisTrigger, Set<AnalysisTrigger>> edgeMap) {
        HashSet<AnalysisTrigger> slice = new HashSet<AnalysisTrigger>();
        ArrayDeque<AnalysisTrigger> workqueue = new ArrayDeque<AnalysisTrigger>(spawnTriggers);
        while (!workqueue.isEmpty()) {
            AnalysisTrigger current = (AnalysisTrigger)workqueue.pop();
            if (slice.contains(current)) continue;
            slice.add(current);
            workqueue.addAll(edgeMap.getOrDefault(current, Collections.emptySet()));
        }
        return slice;
    }

    private static void addTriggerGraphIndexes(List<AnalysisTrigger> remainingTriggers, StringBuilder builder) {
        HashSet stores = new HashSet();
        for (AnalysisTrigger trigger : remainingTriggers) {
            stores.addAll(CollectionUtils.unionSet((Collection)trigger.getWriteStores(), (Collection[])new Collection[]{trigger.getReadBranchingLayerStores(), trigger.getReadOnlyStores(), trigger.getReadStores()}));
        }
        for (String indexName : CollectionUtils.sort(stores)) {
            builder.append("  \"" + indexName + "\"[shape=box, label=\"" + indexName + "\"];" + StringUtils.LINE_SEPARATOR);
        }
    }

    private static void addTriggerDeltaEdges(List<AnalysisTrigger> triggers, StringBuilder builder) {
        ListMap writers = new ListMap();
        for (AnalysisTrigger trigger : triggers) {
            for (String store : trigger.getWriteStores()) {
                writers.add((Object)store, (Object)trigger.getName());
            }
        }
        Set triggerNamesInSlice = triggers.stream().map(AnalysisTrigger::getName).collect(Collectors.toSet());
        for (AnalysisTrigger trigger : triggers) {
            for (String store : trigger.getExpectedDeltaStoreNames()) {
                List writingTriggers = (List)writers.getCollection((Object)store);
                if (CollectionUtils.isNullOrEmpty((Collection)writingTriggers)) continue;
                for (String writingTrigger : CollectionUtils.filter((Collection)writingTriggers, triggerNamesInSlice::contains)) {
                    builder.append("\"" + writingTrigger + "\"->\"" + trigger.getName() + "\"[color=blue, label=\"" + store + "\"];" + StringUtils.LINE_SEPARATOR);
                }
            }
        }
    }

    private static Map<AnalysisTrigger, Set<AnalysisTrigger>> getEdgeMap(List<AnalysisTrigger> allTriggers, boolean forwards) {
        ListMap writers = new ListMap();
        for (AnalysisTrigger trigger : allTriggers) {
            for (String store : trigger.getWriteStores()) {
                writers.add((Object)store, (Object)trigger);
            }
        }
        HashMap<AnalysisTrigger, Set<AnalysisTrigger>> edgeMap = new HashMap<AnalysisTrigger, Set<AnalysisTrigger>>();
        for (AnalysisTrigger trigger : allTriggers) {
            for (String store : trigger.getExpectedDeltaStoreNames()) {
                List writingTriggers = (List)writers.getCollection((Object)store);
                if (CollectionUtils.isNullOrEmpty((Collection)writingTriggers)) continue;
                for (AnalysisTrigger writingTrigger : writingTriggers) {
                    AnalysisTrigger fromTrigger = forwards ? writingTrigger : trigger;
                    AnalysisTrigger toTrigger = forwards ? trigger : writingTrigger;
                    edgeMap.putIfAbsent(fromTrigger, new HashSet());
                    ((Set)edgeMap.get(fromTrigger)).add(toTrigger);
                }
            }
        }
        return edgeMap;
    }
}

