/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.trigger.debug;

import com.teamscale.core.analysis.configuration.TriggerDescription;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.impl.analysis.TriggerIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/triggers/debug")
public class TriggerService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get triggers", description="Returns the names of all triggers configured for the project.", tags={"Debugging"})
    public List<String> getTriggers() throws StorageException {
        return this.getIndex().getAllTriggerNames();
    }

    @GET
    @Path(value="{triggerName}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get trigger", description="Returns the string representation of the given trigger.", tags={"Debugging"})
    public TriggerDescription getTrigger(@PathParam(value="triggerName") String triggerName) throws StorageException {
        return this.getIndex().getTrigger(triggerName);
    }

    @PUT
    @Path(value="{triggerName}")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Set trigger", description="Sets the value of the trigger.", tags={"Debugging"})
    public void updateTrigger(@PathParam(value="triggerName") String triggerName, @RequestBody TriggerDescription triggerValue) throws StorageException {
        this.getIndex().setTrigger(triggerName, triggerValue);
    }

    @DELETE
    @Path(value="{triggerName}")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Delete trigger", description="Removes the trigger from the project.", tags={"Debugging"})
    public void updateTrigger(@PathParam(value="triggerName") String triggerName) throws StorageException {
        this.getIndex().removeTrigger(triggerName);
    }

    private TriggerIndex getIndex() throws StorageException {
        return this.openProjectIndex(TriggerIndex.class, null);
    }
}

