/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.query.TgaCoverageSourceQueryParameters;
import com.teamscale.index.testimpact.SelectedTest;
import com.teamscale.index.testimpact.TestMinimizationJobRun;
import com.teamscale.index.testimpact.TestMinimizationRequestOptions;
import com.teamscale.index.testimpact.TiaRequestOptions;
import com.teamscale.service.PaginationOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.wia.TeamscaleIssueId;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

public interface IAsyncTestMinimizationServiceApi {
    @GET
    @Path(value="jobs")
    @RequiresProjectPermission(value={EProjectPermission.RETRIEVE_TEST_SUGGESTIONS})
    @Operation(summary="Returns the list of test minimization jobs of the current user for the project.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="400", description="One of the given options is invalid.")})
    public List<TestMinimizationJobRun> getJobs() throws StorageException;

    @GET
    @Path(value="jobs/{jobId}")
    @RequiresProjectPermission(value={EProjectPermission.RETRIEVE_TEST_SUGGESTIONS})
    @Operation(summary="Returns the current computation status of a test minimization job.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="404", description="The requested job has not been found."), @ApiResponse(responseCode="400", description="One of the given options is invalid.")})
    public TestMinimizationJobRun getTestMinimizationJobStatus(@PathParam(value="jobId") String var1) throws StorageException;

    @GET
    @Path(value="jobs/{jobId}/options")
    @RequiresProjectPermission(value={EProjectPermission.RETRIEVE_TEST_SUGGESTIONS})
    @Operation(summary="Returns the arguments of the test minimization job.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="404", description="The requested job has not been found.")})
    public TestMinimizationRequestOptions getJobOptions(@PathParam(value="jobId") String var1) throws StorageException;

    @POST
    @Path(value="jobs/{jobId}/tests")
    @RequiresProjectPermission(value={EProjectPermission.RETRIEVE_TEST_SUGGESTIONS})
    @Operation(summary="Sets the list of tests to minimize in the job.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="404", description="The requested job has not been found."), @ApiResponse(responseCode="405", description="The job can currently not be modified.")})
    public int postJobTests(@PathParam(value="jobId") String var1, List<String> var2) throws StorageException;

    @DELETE
    @Path(value="jobs/{jobId}/tests")
    @RequiresProjectPermission(value={EProjectPermission.RETRIEVE_TEST_SUGGESTIONS})
    @Operation(summary="Remove the given list of tests (identified by their current ranking) from the list of tests to minimize in the job.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="404", description="The requested job has not been found."), @ApiResponse(responseCode="405", description="The job can currently not be modified.")})
    public int deleteJobTests(@PathParam(value="jobId") String var1, Set<Integer> var2, @QueryParam(value="deleteMode") EDeleteMode var3) throws StorageException;

    @PUT
    @Path(value="jobs/{jobId}/tests")
    @RequiresProjectPermission(value={EProjectPermission.RETRIEVE_TEST_SUGGESTIONS})
    @Operation(summary="Append the list of tests to minimize to the job based on a query.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="404", description="The requested job has not been found."), @ApiResponse(responseCode="405", description="The job can currently not be modified.")})
    public int putJobTestsFromQuery(@PathParam(value="jobId") String var1, @QueryParam(value="query") String var2, @QueryParam(value="only-with-coverage") @Parameter(description="If true only tests with testwise coverage will be considered") boolean var3) throws StorageException, QueryCompilationException, QueryParsingException;

    @PUT
    @Path(value="jobs/{jobId}/tests-from-impacted")
    @RequiresProjectPermission(value={EProjectPermission.RETRIEVE_TEST_SUGGESTIONS})
    @Operation(summary="Append the list of impacted tests as tests to minimize to the job.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="404", description="The requested job has not been found."), @ApiResponse(responseCode="405", description="The job can currently not be modified.")})
    public int putJobTestsFromImpacted(@PathParam(value="jobId") String var1, @BeanParam TiaRequestOptions var2, @QueryParam(value="cross-annotation-project-patterns") List<String> var3, @QueryParam(value="test-gaps-only") boolean var4) throws StorageException, InterruptedException;

    @POST
    @Path(value="jobs")
    @RequiresProjectPermission(value={EProjectPermission.RETRIEVE_TEST_SUGGESTIONS})
    @Operation(summary="Request the computation of a minimized test set.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="412", description="The given commit has not been processed yet."), @ApiResponse(responseCode="400", description="One of the given options is invalid.")})
    public String setupJob(@BeanParam TestMinimizationRequestOptions var1) throws StorageException;

    @PUT
    @Path(value="jobs/{jobId}")
    @RequiresProjectPermission(value={EProjectPermission.RETRIEVE_TEST_SUGGESTIONS})
    @Operation(summary="Updates the minimization options for the given job.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="412", description="The given commit has not been processed yet."), @ApiResponse(responseCode="400", description="One of the given options is invalid.")})
    public void updateJobOptions(@PathParam(value="jobId") String var1, @BeanParam TestMinimizationRequestOptions var2) throws StorageException;

    @POST
    @Path(value="jobs/{jobId}/start")
    @RequiresProjectPermission(value={EProjectPermission.TEST_SELECTION_RANKING})
    @Operation(summary="Starts the given test minimization job.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="404", description="The requested job has not been found.")})
    public void startJob(@PathParam(value="jobId") String var1) throws StorageException;

    @DELETE
    @Path(value="jobs/{jobId}")
    @RequiresProjectPermission(value={EProjectPermission.RETRIEVE_TEST_SUGGESTIONS})
    @Operation(summary="Stops and deletes the given test minimization job and its results.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="404", description="The requested job has not been found."), @ApiResponse(responseCode="400", description="One of the given options is invalid.")})
    public void stopAndDeleteMinimizationJob(@PathParam(value="jobId") String var1) throws StorageException;

    @GET
    @Path(value="risks")
    @RequiresProjectPermission(value={EProjectPermission.RETRIEVE_TEST_SUGGESTIONS})
    @Operation(summary="Get risk methods along with an origin of the risk", description="Returns all methods that are considered a risk and should therefore be covered with tests. These are either risks because there were changes to the methods in the given time range, or these methods were changed in context of the given issues (defined by an issue query). Along with each method, we provide the last timestamps (long values) of changes and the issue ids in context of that these changes were made.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="404", description="The requested job has not been found.")})
    public PairList<MethodLocation, PairList<Long, Set<TeamscaleIssueId>>> getRisks(@Parameter(description="Uniform path to retrieve data for", allowEmptyValue=true) @DefaultValue(value="") @QueryParam(value="uniform-path") UniformPath var1, @BeanParam TgaCoverageSourceQueryParameters var2, @Parameter(description="The baseline commit (inclusive). This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided or \"HEAD\" to refer to the most recent commit. This can optionally be prefixed by the name of the branch, followed by a colon (by default, we use the default branch). You can append a \"p1\" to resolve to the immediate parent of the most recent commit at the given branch/timestamp. p2 would resolve to the parent of the immediate parent and so on. In merge commits, the parent resolution considers only the first parent. You can append \"e\" to include the potential external report uploads of the commit. A parameter value that uses all features would be \"master:1601637680000p1e\"") @QueryParam(value="baseline") @Nullable UnresolvedCommitDescriptor var3, @Parameter(description="The end commit (inclusive). This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided or \"HEAD\" to refer to the most recent commit. This can optionally be prefixed by the name of the branch, followed by a colon (by default, we use the default branch). You can append a \"p1\" to resolve to the immediate parent of the most recent commit at the given branch/timestamp. p2 would resolve to the parent of the immediate parent and so on. In merge commits, the parent resolution considers only the first parent. You can append \"e\" to include the potential external report uploads of the commit. A parameter value that uses all features would be \"master:1601637680000p1e\"") @QueryParam(value="end") UnresolvedCommitDescriptor var4, @QueryParam(value="test-gaps-only") @Parameter(description="Restrict the changes since the given baseline to test gaps?") boolean var5, @QueryParam(value="issue-query") @Parameter(description="Given an issue query that selects a set of issues. All methods that where changed by any of these issues are returned as risks.") @Nullable String var6) throws StorageException, ExecutionException, InterruptedException;

    @POST
    @Path(value="jobs/{jobId}/tests/save-as-named-list")
    @RequiresProjectPermission(value={EProjectPermission.TEST_SELECTION_RANKING})
    @Operation(summary="Saves the list of tests created along this job as a named test list.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="404", description="The requested job has not been found.")})
    public int saveAsNamedTestList(@PathParam(value="jobId") String var1, String var2) throws StorageException;

    @POST
    @Path(value="jobs/{jobId}/tests/load-from-named-list")
    @RequiresProjectPermission(value={EProjectPermission.TEST_SELECTION_RANKING})
    @Operation(summary="Load the list of tests of this job from a named test list.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="404", description="The requested job has not been found.")})
    public int loadFromNamedTestList(@PathParam(value="jobId") String var1, @QueryParam(value="testListName") String var2, @QueryParam(value="replaceTests") boolean var3) throws StorageException;

    @GET
    @Path(value="jobs/{jobId}/tests")
    @RequiresProjectPermission(value={EProjectPermission.RETRIEVE_TEST_SUGGESTIONS})
    @Operation(summary="Returns the currently selected list of test (possibly Pareto ranked).", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="404", description="The requested job has not been found."), @ApiResponse(responseCode="400", description="One of the given options is invalid.")})
    public List<SelectedTest> getSelectedTests(@PathParam(value="jobId") String var1, @BeanParam PaginationOptions var2) throws StorageException;

    @GET
    @Path(value="jobs/{jobId}/tests/csv")
    @Operation(summary="Returns the (possibly ranked) list of tests that have been selected for this job as CSV.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="404", description="The requested job has not been found."), @ApiResponse(responseCode="400", description="One of the given options is invalid.")})
    @RequiresProjectPermission(value={EProjectPermission.RETRIEVE_TEST_SUGGESTIONS})
    @Produces(value={"text/csv"})
    public Response downloadTestSelectionCsv(@PathParam(value="jobId") String var1, @QueryParam(value="timeBudgetMillis") long var2) throws StorageException;

    @GET
    @Path(value="jobs/{jobId}/tests/additional-coverage")
    @RequiresProjectPermission(value={EProjectPermission.RETRIEVE_TEST_SUGGESTIONS})
    @Operation(summary="Returns a list of sets of additionally covered methods. ", description="The set on position i denotes that executing the test corresponding to position i covers additionally (relative to the methods covered by tests 0 to i-1) the methods described in the set.", tags={"Test Intelligence"}, responses={@ApiResponse(responseCode="200", description="A list of lists of additionally covered method IDs (element on position i: additional coverage after executing tests 0 to i-1)", content={@Content(mediaType="application/json", schema=@Schema(implementation=MethodLocation[][].class))}), @ApiResponse(responseCode="404", description="The requested job has not been found."), @ApiResponse(responseCode="400", description="One of the given options is invalid.")})
    public Response getAdditionallyCoveredMethods(@PathParam(value="jobId") String var1) throws StorageException;

    @ExportToTypeScript
    public static enum EDeleteMode {
        ONLY_GIVEN,
        ALL;

    }
}

