/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.treemap;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.testgap.treemap.MethodTreeMapNodeBase;
import com.teamscale.service.treemap.CoverageMethodTreeMapNode;
import com.teamscale.service.treemap.FindingsResolvedMethodTreeMapNode;
import com.teamscale.wia.TeamscaleIssueId;
import io.swagger.v3.oas.annotations.media.Schema;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.test.NoIndexValueClass;
import org.jspecify.annotations.Nullable;

@NoIndexValueClass(rationale="Only used as DTO")
@Schema(allOf={MethodTreeMapNodeBase.class}, subTypes={CoverageMethodTreeMapNode.class, FindingsResolvedMethodTreeMapNode.class})
public abstract sealed class MethodBasedTreeMapNodeBase
extends MethodTreeMapNodeBase
permits CoverageMethodTreeMapNode, FindingsResolvedMethodTreeMapNode {
    @JsonProperty(value="matchingIssues")
    private Set<TeamscaleIssueId> matchingIssues;
    @JsonProperty(value="color")
    private @Nullable Color color = null;
    @JsonProperty(value="colorValue")
    private @Nullable String colorValue = null;

    protected MethodBasedTreeMapNodeBase(String uniformPath) {
        super(uniformPath);
        this.matchingIssues = Collections.emptySet();
    }

    protected MethodBasedTreeMapNodeBase(String uniformPath, OffsetBasedRegion region, String methodName, Collection<TeamscaleIssueId> matchingIssues) {
        super(uniformPath, region, methodName);
        this.matchingIssues = new HashSet<TeamscaleIssueId>(matchingIssues);
        this.area = region.getLength();
    }

    public int getNumberOfMatchingIssues() {
        return this.matchingIssues.size();
    }

    public void setColor(Color color, String colorValue) {
        Objects.requireNonNull(color, "color");
        Objects.requireNonNull(colorValue, "colorValue");
        this.color = color;
        this.colorValue = colorValue;
    }

    public @Nullable Color getColor() {
        return this.color;
    }

    public void aggregateValues() {
        if (this.getChildren().isEmpty()) {
            return;
        }
        this.matchingIssues = this.getChildren().stream().flatMap(child -> ((MethodBasedTreeMapNodeBase)child).matchingIssues.stream()).collect(Collectors.toSet());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializationUtils.unsupportedWriteObject((ObjectOutputStream)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        SerializationUtils.unsupportedReadObject((ObjectInputStream)in);
    }
}

