/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.util;

import java.nio.ByteOrder;
import us.hebi.matlab.mat.util.ByteConverter;
import us.hebi.matlab.mat.util.UnsafeAccess;

class UnsafeByteConverter
implements ByteConverter {
    @Override
    public short getShort(ByteOrder order, byte[] bytes, int offset) {
        short value = UnsafeAccess.UNSAFE.getShort(bytes, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset);
        if (order == UnsafeAccess.NATIVE_ORDER) {
            return value;
        }
        return Short.reverseBytes(value);
    }

    @Override
    public int getInt(ByteOrder order, byte[] bytes, int offset) {
        int value = UnsafeAccess.UNSAFE.getInt(bytes, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset);
        if (order == UnsafeAccess.NATIVE_ORDER) {
            return value;
        }
        return Integer.reverseBytes(value);
    }

    @Override
    public long getLong(ByteOrder order, byte[] bytes, int offset) {
        long value = UnsafeAccess.UNSAFE.getLong(bytes, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset);
        if (order == UnsafeAccess.NATIVE_ORDER) {
            return value;
        }
        return Long.reverseBytes(value);
    }

    @Override
    public float getFloat(ByteOrder order, byte[] bytes, int offset) {
        if (order == UnsafeAccess.NATIVE_ORDER) {
            return UnsafeAccess.UNSAFE.getFloat(bytes, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset);
        }
        int bits = UnsafeAccess.UNSAFE.getInt(bytes, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset);
        return Float.intBitsToFloat(Integer.reverseBytes(bits));
    }

    @Override
    public double getDouble(ByteOrder order, byte[] bytes, int offset) {
        if (order == UnsafeAccess.NATIVE_ORDER) {
            return UnsafeAccess.UNSAFE.getDouble(bytes, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset);
        }
        long bits = UnsafeAccess.UNSAFE.getLong(bytes, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset);
        return Double.longBitsToDouble(Long.reverseBytes(bits));
    }

    @Override
    public void putShort(short value, ByteOrder order, byte[] bytes, int offset) {
        if (order != UnsafeAccess.NATIVE_ORDER) {
            value = Short.reverseBytes(value);
        }
        UnsafeAccess.UNSAFE.putShort(bytes, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, value);
    }

    @Override
    public void putInt(int value, ByteOrder order, byte[] bytes, int offset) {
        if (order != UnsafeAccess.NATIVE_ORDER) {
            value = Integer.reverseBytes(value);
        }
        UnsafeAccess.UNSAFE.putInt(bytes, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, value);
    }

    @Override
    public void putLong(long value, ByteOrder order, byte[] bytes, int offset) {
        if (order != UnsafeAccess.NATIVE_ORDER) {
            value = Long.reverseBytes(value);
        }
        UnsafeAccess.UNSAFE.putLong(bytes, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, value);
    }

    @Override
    public void putFloat(float value, ByteOrder order, byte[] bytes, int offset) {
        if (order == UnsafeAccess.NATIVE_ORDER) {
            UnsafeAccess.UNSAFE.putFloat(bytes, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, value);
        } else {
            int bits = Integer.reverseBytes(Float.floatToRawIntBits(value));
            UnsafeAccess.UNSAFE.putInt(bytes, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, bits);
        }
    }

    @Override
    public void putDouble(double value, ByteOrder order, byte[] bytes, int offset) {
        if (order == UnsafeAccess.NATIVE_ORDER) {
            UnsafeAccess.UNSAFE.putDouble(bytes, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, value);
        } else {
            long bits = Long.reverseBytes(Double.doubleToRawLongBits(value));
            UnsafeAccess.UNSAFE.putLong(bytes, UnsafeAccess.BYTE_ARRAY_OFFSET + (long)offset, bits);
        }
    }

    UnsafeByteConverter() {
        UnsafeAccess.requireUnsafe();
    }
}

