/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.error;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.conqat.engine.persistence.index.keyed.query.lexer.QueryToken;
import org.jspecify.annotations.Nullable;

public class QueryParsingException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final @Nullable QueryToken token;

    public QueryParsingException(String message, Throwable cause, List<QueryToken> tokens) {
        super(message, cause);
        this.token = tokens.isEmpty() ? null : Objects.requireNonNull(tokens.get(0));
    }

    public QueryParsingException(String message, List<QueryToken> tokens) {
        this(message, null, tokens);
    }

    public QueryParsingException(String message, Throwable cause, QueryToken ... tokens) {
        this(message, cause, Arrays.asList(tokens));
    }

    public QueryParsingException(String message, QueryToken ... tokens) {
        this(message, null, Arrays.asList(tokens));
    }

    @Override
    public String toString() {
        return super.toString() + this.getTokenString();
    }

    private String getTokenString() {
        String message = this.getToken().map(token -> String.valueOf(token) + ", ").orElse("");
        return "\nToken encountered: " + message;
    }

    public Optional<QueryToken> getToken() {
        return Optional.ofNullable(this.token);
    }
}

