/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.staxmate;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.io.Stax2ByteArraySource;
import org.codehaus.stax2.ri.Stax2ReaderAdapter;
import org.codehaus.staxmate.in.SMFilter;
import org.codehaus.staxmate.in.SMFilterFactory;
import org.codehaus.staxmate.in.SMFlatteningCursor;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputContext;

public final class SMInputFactory {
    final XMLInputFactory _staxFactory;
    final XMLInputFactory2 _stax2Factory;

    public SMInputFactory(XMLInputFactory staxF) {
        this._staxFactory = staxF;
        this._stax2Factory = staxF instanceof XMLInputFactory2 ? (XMLInputFactory2)staxF : null;
    }

    public XMLInputFactory getStaxFactory() {
        return this._staxFactory;
    }

    public static SMHierarchicCursor hierarchicCursor(XMLStreamReader sr, SMFilter f) {
        return SMInputFactory.constructHierarchic(SMInputFactory.wrapIfNecessary(sr), f);
    }

    public static SMFlatteningCursor flatteningCursor(XMLStreamReader sr, SMFilter f) {
        return SMInputFactory.constructFlattening(SMInputFactory.wrapIfNecessary(sr), f);
    }

    public static SMHierarchicCursor rootElementCursor(XMLStreamReader sr) {
        return SMInputFactory.hierarchicCursor(sr, SMFilterFactory.getElementOnlyFilter());
    }

    public static SMHierarchicCursor rootCursor(XMLStreamReader sr) {
        return SMInputFactory.hierarchicCursor(sr, null);
    }

    public XMLStreamReader2 createStax2Reader(URL url) throws XMLStreamException {
        if (this._stax2Factory != null) {
            return this._stax2Factory.createXMLStreamReader(url);
        }
        try {
            XMLStreamReader sr = this._staxFactory.createXMLStreamReader(url.toExternalForm(), url.openStream());
            return SMInputFactory.wrapIfNecessary(sr);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    public XMLStreamReader2 createStax2Reader(File f) throws XMLStreamException {
        if (this._stax2Factory != null) {
            return this._stax2Factory.createXMLStreamReader(f);
        }
        try {
            String sysId = f.toURL().toExternalForm();
            XMLStreamReader sr = this._staxFactory.createXMLStreamReader(sysId, new FileInputStream(f));
            return SMInputFactory.wrapIfNecessary(sr);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    public XMLStreamReader2 createStax2Reader(byte[] data2, int offset, int len) throws XMLStreamException {
        Stax2ByteArraySource src = new Stax2ByteArraySource(data2, offset, len);
        if (this._stax2Factory != null) {
            return (XMLStreamReader2)this._stax2Factory.createXMLStreamReader(src);
        }
        try {
            XMLStreamReader sr = this._staxFactory.createXMLStreamReader(src.constructInputStream());
            return SMInputFactory.wrapIfNecessary(sr);
        }
        catch (IOException ioe) {
            throw new XMLStreamException(ioe);
        }
    }

    public XMLStreamReader2 createStax2Reader(InputStream in) throws XMLStreamException {
        return SMInputFactory.wrapIfNecessary(this._staxFactory.createXMLStreamReader(in));
    }

    public XMLStreamReader2 createStax2Reader(Reader r) throws XMLStreamException {
        return SMInputFactory.wrapIfNecessary(this._staxFactory.createXMLStreamReader(r));
    }

    public SMHierarchicCursor rootElementCursor(URL url) throws XMLStreamException {
        return SMInputFactory.constructHierarchic(this.createStax2Reader(url), SMFilterFactory.getElementOnlyFilter());
    }

    public SMHierarchicCursor rootElementCursor(File f) throws XMLStreamException {
        return SMInputFactory.constructHierarchic(this.createStax2Reader(f), SMFilterFactory.getElementOnlyFilter());
    }

    public SMHierarchicCursor rootElementCursor(byte[] data2, int offset, int len) throws XMLStreamException {
        return SMInputFactory.constructHierarchic(this.createStax2Reader(data2, offset, len), SMFilterFactory.getElementOnlyFilter());
    }

    public SMHierarchicCursor rootElementCursor(InputStream in) throws XMLStreamException {
        return SMInputFactory.constructHierarchic(this.createStax2Reader(in), SMFilterFactory.getElementOnlyFilter());
    }

    public SMHierarchicCursor rootElementCursor(Reader r) throws XMLStreamException {
        return SMInputFactory.constructHierarchic(this.createStax2Reader(r), SMFilterFactory.getElementOnlyFilter());
    }

    public SMFlatteningCursor flatteningCursor(File input, SMFilter f) throws XMLStreamException {
        return SMInputFactory.constructFlattening(this.createStax2Reader(input), f);
    }

    public SMFlatteningCursor flatteningCursor(URL input, SMFilter f) throws XMLStreamException {
        return SMInputFactory.constructFlattening(this.createStax2Reader(input), f);
    }

    public SMFlatteningCursor flatteningCursor(InputStream input, SMFilter f) throws XMLStreamException {
        return SMInputFactory.constructFlattening(this.createStax2Reader(input), f);
    }

    public SMFlatteningCursor flatteningCursor(Reader r, SMFilter f) throws XMLStreamException {
        return SMInputFactory.constructFlattening(this.createStax2Reader(r), f);
    }

    public static SMInputFactory getGlobalSMInputFactory() throws FactoryConfigurationError {
        return SMFactoryAccessor.getFactory();
    }

    public static XMLInputFactory getGlobalXMLInputFactory() throws FactoryConfigurationError {
        return XmlFactoryAccessor.getFactory();
    }

    protected static final SMHierarchicCursor constructHierarchic(XMLStreamReader2 sr, SMFilter f) {
        SMInputContext ctxt = new SMInputContext(sr);
        return new SMHierarchicCursor(ctxt, null, f);
    }

    protected static final SMFlatteningCursor constructFlattening(XMLStreamReader2 sr, SMFilter f) {
        SMInputContext ctxt = new SMInputContext(sr);
        return new SMFlatteningCursor(ctxt, null, f);
    }

    protected static final XMLStreamReader2 wrapIfNecessary(XMLStreamReader sr) {
        return Stax2ReaderAdapter.wrapIfNecessary(sr);
    }

    private static final class SMFactoryAccessor {
        static final SMFactoryAccessor sInstance = new SMFactoryAccessor();
        SMInputFactory mFactory = null;

        private SMFactoryAccessor() {
        }

        public static SMInputFactory getFactory() throws FactoryConfigurationError {
            return sInstance.get();
        }

        private synchronized SMInputFactory get() throws FactoryConfigurationError {
            if (this.mFactory == null) {
                this.mFactory = new SMInputFactory(XmlFactoryAccessor.getFactory());
            }
            return this.mFactory;
        }
    }

    private static final class XmlFactoryAccessor {
        static final XmlFactoryAccessor sInstance = new XmlFactoryAccessor();
        XMLInputFactory mFactory = null;

        private XmlFactoryAccessor() {
        }

        public static XMLInputFactory getFactory() throws FactoryConfigurationError {
            return sInstance.get();
        }

        private synchronized XMLInputFactory get() throws FactoryConfigurationError {
            if (this.mFactory == null) {
                this.mFactory = XMLInputFactory.newInstance();
            }
            return this.mFactory;
        }
    }
}

