/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.FunMatcherImpl;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.checks.WeakSSLContextCheck;

@Rule(key="S4423")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0018\u001a\u0004\u0018\u00010\b*\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/sonarsource/kotlin/checks/WeakSSLContextCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "()V", "OKHTTP_MATCHER", "Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "SSL_CONTEXT_MATCHER", "WEAK_FOR_OK_HTTP", "", "", "WEAK_FOR_SSL", "handleOkHttp", "", "node", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "handleSSL", "reportUnsecureSSLContext", "unsecureVersions", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitCallExpression", "value", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nWeakSSLContextCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WeakSSLContextCheck.kt\norg/sonarsource/kotlin/checks/WeakSSLContextCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1603#2,9:143\n1855#2:152\n1856#2:154\n1612#2:155\n766#2:156\n857#2,2:157\n1549#2:159\n1620#2,3:160\n1#3:153\n*S KotlinDebug\n*F\n+ 1 WeakSSLContextCheck.kt\norg/sonarsource/kotlin/checks/WeakSSLContextCheck\n*L\n100#1:143,9\n100#1:152\n100#1:154\n100#1:155\n101#1:156\n101#1:157,2\n117#1:159\n117#1:160,3\n100#1:153\n*E\n"})
public final class WeakSSLContextCheck
extends AbstractCheck {
    @NotNull
    private final Set<String> WEAK_FOR_OK_HTTP;
    @NotNull
    private final Set<String> WEAK_FOR_SSL;
    @NotNull
    private final FunMatcherImpl OKHTTP_MATCHER;
    @NotNull
    private final FunMatcherImpl SSL_CONTEXT_MATCHER;

    public WeakSSLContextCheck() {
        String[] stringArray = new String[]{"TLSv1", "TLSv1.1", "TLS_1_0", "TLS_1_1", "okhttp3.TlsVersion.TLS_1_0", "okhttp3.TlsVersion.TLS_1_1"};
        this.WEAK_FOR_OK_HTTP = SetsKt.setOf(stringArray);
        stringArray = new String[]{"SSL", "TLS", "DTLS", "SSLv2", "SSLv3", "TLSv1", "TLSv1.1", "DTLSv1.0"};
        this.WEAK_FOR_SSL = SetsKt.setOf(stringArray);
        this.OKHTTP_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, OKHTTP_MATCHER.1.INSTANCE, 1023, null);
        this.SSL_CONTEXT_MATCHER = FunMatcherKt.FunMatcher$default(null, null, null, null, false, null, null, null, null, null, SSL_CONTEXT_MATCHER.1.INSTANCE, 1023, null);
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression node, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        BindingContext bindingContext2 = kotlinFileContext.getBindingContext();
        if (this.SSL_CONTEXT_MATCHER.matches(node, bindingContext2)) {
            this.handleSSL(node, bindingContext2, kotlinFileContext);
        } else if (this.OKHTTP_MATCHER.matches(node, bindingContext2)) {
            this.handleOkHttp(node, bindingContext2, kotlinFileContext);
        }
    }

    private final void handleSSL(KtCallExpression node, BindingContext bindingContext2, KotlinFileContext kotlinFileContext) {
        block1: {
            KtExpression ktExpression;
            List<KtValueArgument> list2 = node.getValueArguments();
            Intrinsics.checkNotNullExpressionValue(list2, "getValueArguments(...)");
            KtValueArgument ktValueArgument = CollectionsKt.firstOrNull(list2);
            if (ktValueArgument == null || (ktExpression = ktValueArgument.getArgumentExpression()) == null) break block1;
            KtExpression it = ktExpression;
            boolean bl = false;
            if (CollectionsKt.contains((Iterable)this.WEAK_FOR_SSL, this.value(it, bindingContext2))) {
                this.reportUnsecureSSLContext(CollectionsKt.listOf(it), kotlinFileContext);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleOkHttp(KtCallExpression node, BindingContext bindingContext2, KotlinFileContext kotlinFileContext) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        List<KtValueArgument> list2 = node.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list2, "getValueArguments(...)");
        Iterable iterable = list2;
        boolean $i$f$mapNotNull = false;
        void var7_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtExpression it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtValueArgument it = (KtValueArgument)element$iv$iv;
            boolean bl2 = false;
            if (it.getArgumentExpression() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtExpression it = (KtExpression)element$iv$iv;
            boolean bl = false;
            Iterable iterable2 = this.WEAK_FOR_OK_HTTP;
            Intrinsics.checkNotNull(it);
            if (!CollectionsKt.contains(iterable2, this.value(it, bindingContext2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unsecureVersions = (List)destination$iv$iv;
        this.reportUnsecureSSLContext(unsecureVersions, kotlinFileContext);
    }

    /*
     * WARNING - void declaration
     */
    private final void reportUnsecureSSLContext(List<? extends KtExpression> unsecureVersions, KotlinFileContext kotlinFileContext) {
        if (!((Collection)unsecureVersions).isEmpty()) {
            Collection<SecondaryLocation> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List<KtExpression> secondaries = CollectionsKt.minus((Iterable)unsecureVersions, unsecureVersions.get(0));
            Iterable iterable = secondaries;
            String string2 = "Change this code to use a stronger protocol.";
            PsiElement psiElement = unsecureVersions.get(0);
            KotlinFileContext kotlinFileContext2 = kotlinFileContext;
            AbstractCheck abstractCheck = this;
            boolean $i$f$map = false;
            void var6_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtExpression ktExpression = (KtExpression)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(kotlinFileContext, (PsiElement)it), "Other weak protocol."));
            }
            collection = (List)destination$iv$iv;
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext2, psiElement, string2, (List)collection, null, 8, null);
        }
    }

    private final String value(KtExpression $this$value, BindingContext bindingContext2) {
        String string2;
        KtExpression ktExpression = $this$value;
        if (ktExpression instanceof KtStringTemplateExpression) {
            string2 = this.asConstant((KtStringTemplateExpression)$this$value);
        } else if (ktExpression instanceof KtNameReferenceExpression) {
            DeclarationDescriptor descriptor2 = (DeclarationDescriptor)bindingContext2.get(BindingContext.REFERENCE_TARGET, $this$value);
            if (descriptor2 instanceof PropertyDescriptor) {
                ConstantValue<?> constantValue = ((PropertyDescriptor)descriptor2).getCompileTimeInitializer();
                string2 = String.valueOf(constantValue != null ? constantValue.boxedValue() : null);
            } else {
                string2 = null;
            }
        } else {
            Object object;
            KtExpression selectorExpression;
            string2 = ktExpression instanceof KtDotQualifiedExpression ? ((selectorExpression = ((KtDotQualifiedExpression)$this$value).getSelectorExpression()) instanceof KtNameReferenceExpression ? ((object = (DeclarationDescriptor)bindingContext2.get(BindingContext.REFERENCE_TARGET, selectorExpression)) != null && (object = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)object)) != null ? ((FqName)object).asString() : null) : null) : null;
        }
        return string2;
    }
}

