# Description
Finds `TYPE BEGIN` with just one `INCLUDE TYPE`, and `DATA` with single `INCLUDE STRUCTURE`

# Examples
**Bad example**
```abap
TYPES: BEGIN OF dummy1.
  INCLUDE TYPE dselc.
TYPES: END OF dummy1.

DATA BEGIN OF foo.
INCLUDE STRUCTURE syst.
DATA END OF foo.

STATICS BEGIN OF bar.
INCLUDE STRUCTURE syst.
STATICS END OF bar.
```

**Good example**
```abap
DATA BEGIN OF foo.
INCLUDE STRUCTURE dselc.
DATA END OF foo.
```

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/begin_single_include) <br>
