The use of hard-coded passwords increases the possibility of password
guessing tremendously. This plugin test looks for all function calls being
passed a keyword argument that is a string literal. It checks that the
assigned local variable does not look like a password.

Variables are considered to look like a password if they have match any one
of:

- "password"
- "pass"
- "passwd"
- "pwd"
- "secret"
- "token"
- "secrete"

Note: this can be noisy and may generate false positives.

**Config Options:**

None

## Example


In the following code snippet the issue is: [B106:hardcoded_password_funcarg] Possible hardcoded
password: 'blerg'
For more information on this see: CWE-259 (https://cwe.mitre.org/data/definitions/259.html)
``` python

   doLogin(password="blerg")
```
## see also:

- https://www.owasp.org/index.php/Use_of_hard-coded_password
- https://cwe.mitre.org/data/definitions/259.html

New in version  0.9.0

Changed in version  1.7.3
CWE information added
