# Rule 3.1 The character sequences /* and // shall not be used within a comment

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Rationale
If a comment starting sequence, `/*` or `//`, occurs within a `/*` comment, is it quite likely to be caused by a missing `*/` comment ending sequence.

If a comment starting sequence occurs within a `//` comment, it is probably because a region of code has been commented-out using `//`.

## Exception
The sequence `//` is permitted within a `//` comment.

## Example
Consider the following code fragment:

```c
/* some comment, end comment marker accidentally omitted
<<New Page>>
Perform_Critical_Safety_Function( X );
/* this comment is non-compliant */
```

In reviewing the page containing the call to the function, the assumption is that it is executed code. Because of the accidental omission of the end comment marker, the call to the safety critical function will not be executed.

In the following C99 example, the presence of `//` comments changes the meaning of the program:

```c
x = y // /*
    + z
    // */
    ;
```

This gives `x = y + z;` but would have been `x = y;` in the absence of the two `//` comment start sequences.

## See also
Dir 4.4

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
